/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.select;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.config.SelectValuesProvider;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@Named(value="SelectBoxFieldHandlerFormatter")
public class SelectBoxFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    public static final String PARAM_MODE = "show_mode";
    public static final String MODE_SHOW = "show";
    public static final String MODE_INPUT = "input";
    @Inject
    private FormRenderContextManager formRenderContextManager;

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        String mode = (String)this.getParameter(PARAM_MODE);
        if (MODE_INPUT.equals(mode)) {
            this.renderInput(request);
        } else {
            this.renderShow(request);
        }
    }

    public void renderShow(HttpServletRequest request) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        if (StringUtils.isEmpty((CharSequence)field.getCustomFieldType())) {
            return;
        }
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        SelectValuesProvider provider = (SelectValuesProvider)CDIBeanLocator.getBeanByNameOrType((String)field.getCustomFieldType());
        Map fieldRange = provider.getSelectOptions(field, (String)value, this.formRenderContextManager.getRootContext(fieldName), this.getLocale());
        if (fieldRange == null || fieldRange.isEmpty()) {
            return;
        }
        String text = (String)fieldRange.get(value);
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.setAttribute("value", text);
        this.renderFragment("output");
    }

    public void renderInput(HttpServletRequest request) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        String fieldName = paramsReader.getCurrentFieldName();
        String uid = this.namespaceManager.squashInputName(fieldName);
        Boolean isReadonly = paramsReader.isFieldReadonly() != false || field.getReadonly() != false;
        this.setAttribute("size", 1);
        this.setAttribute("name", fieldName);
        this.setAttribute("uid", uid);
        this.setDefaultAttributes(field, paramsReader.getCurrentForm(), paramsReader.getCurrentNamespace());
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        this.setAttribute("onChangeScript", field.getOnChangeScript());
        this.renderFragment("outputStart");
        this.renderFragment("outputOption");
        if (!StringUtils.isEmpty((CharSequence)field.getCustomFieldType())) {
            Object value = paramsReader.getCurrentFieldValue();
            SelectValuesProvider provider = (SelectValuesProvider)CDIBeanLocator.getBeanByNameOrType((String)field.getCustomFieldType());
            Map fieldRange = provider.getSelectOptions(field, (String)value, this.formRenderContextManager.getRootContext(fieldName), this.getLocale());
            if (fieldRange != null && !fieldRange.isEmpty()) {
                String keyValueStr = StringEscapeUtils.escapeHtml4((String)StringUtils.defaultString((String)(value == null ? "" : String.valueOf(value))));
                for (Object key : fieldRange.keySet()) {
                    this.setAttribute("key", key);
                    String valueKey = (String)fieldRange.get(key);
                    this.setAttribute("value", valueKey);
                    if (keyValueStr != null && keyValueStr.equals(key.toString())) {
                        this.renderFragment("outputSelectedOption");
                        continue;
                    }
                    this.renderFragment("outputOption");
                }
            }
        }
        this.renderFragment("outputEnd");
    }
}

