/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.mocks.SubformFinderServiceMock;
import org.jbpm.formModeler.core.processing.impl.AbstractFormProcessorImplTest;
import org.jbpm.formModeler.core.processing.impl.model.Address;
import org.jbpm.formModeler.core.processing.impl.model.Hobby;
import org.jbpm.formModeler.core.processing.impl.model.Person;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SubformDataFormProcessorImplTest
extends AbstractFormProcessorImplTest {
    public static final String ORIGINAL_NAME = "Aria";
    public static final String ORIGINAL_SURNAME = "Stark";
    public static final Date ORIGINAL_DATE = new Date(System.currentTimeMillis() - 1500L);
    public static final String ORIGINAL_STREET = "Winterfell";
    public static final Integer ORIGINAL_NUMBER = 2;
    public static final String ORIGINAL_HOBBY_NAME = "Kill kill kill!";
    public static final Integer ORIGINAL_HOBBY_LEVEL = 10;
    public static final String EXPECTED_NAME = "John";
    public static final String EXPECTED_SURNAME = "Snow";
    public static final Date EXPECTED_DATE = new Date();
    public static final String EXPECTED_STREET = "Black Castle";
    public static final Integer EXPECTED_NUMBER = 1;
    public static final String EXPECTED_HOBBY1_NAME = "Fighting";
    public static final Integer EXPECTED_HOBBY1_LEVEL = 10;
    public static final String EXPECTED_HOBBY2_NAME = "Return from dead";
    public static final Integer EXPECTED_HOBBY2_LEVEL = 7;
    protected SubformFinderServiceMock subformFinderService;
    private Person expectedPerson;
    private Form addressForm;
    private Form hobbyForm;

    @Override
    public void init() {
        super.init();
        ArrayList<Hobby> hobbyList = new ArrayList<Hobby>();
        hobbyList.add(new Hobby(EXPECTED_HOBBY1_NAME, EXPECTED_HOBBY1_LEVEL));
        hobbyList.add(new Hobby(EXPECTED_HOBBY2_NAME, EXPECTED_HOBBY2_LEVEL));
        this.expectedPerson = new Person(EXPECTED_NAME, EXPECTED_SURNAME, EXPECTED_DATE, new Address(EXPECTED_STREET, EXPECTED_NUMBER), hobbyList);
        this.form = this.formGenerator.generatePersonForm();
        this.addressForm = this.formGenerator.generateAddressForm();
        this.hobbyForm = this.formGenerator.generateHobbyForm();
        this.form.getSubForms().put(this.addressForm.getId(), this.addressForm);
        this.form.getSubForms().put(this.hobbyForm.getId(), this.hobbyForm);
        this.subformFinderService = (SubformFinderServiceMock)this.weldContainer.instance().select(SubformFinderServiceMock.class, new Annotation[0]).get();
        this.subformFinderService.addFormContext(this.form);
        this.subformFinderService.addForm(this.addressForm);
        this.subformFinderService.addForm(this.hobbyForm);
    }

    @Test
    public void testPersistComplexDataWithoutInputs() throws Exception {
        this.initContext();
        FormStatusData data = this.processor.read("ctxUID");
        Assert.assertNotNull((Object)data);
        Object name = data.getCurrentValue("name");
        Assert.assertNull((Object)name);
        Object surname = data.getCurrentValue("surname");
        Assert.assertNull((Object)surname);
        Object birthday = data.getCurrentValue("birthday");
        Assert.assertNull((Object)birthday);
        Object address = data.getCurrentValue("address");
        Assert.assertNotNull((Object)address);
        Assert.assertTrue((boolean)(address instanceof Map));
        Assert.assertTrue((boolean)((Map)address).isEmpty());
        Object hobbies = data.getCurrentValue("hobbies");
        Assert.assertNotNull((Object)hobbies);
        Assert.assertTrue((boolean)(hobbies instanceof Map[]));
        Assert.assertEquals((long)0L, (long)((Map[])hobbies).length);
        Mockito.when((Object)this.processor.getFilteredMapRepresentationToPersist(this.context.getForm(), this.context.getUID())).thenReturn((Object)this.generateExpectedValuesMap());
        this.processor.persist("ctxUID");
        Assert.assertNotNull(this.context.getOutputData().get("person"));
        Assert.assertTrue((boolean)(this.context.getOutputData().get("person") instanceof Person));
        Person person = (Person)this.context.getOutputData().get("person");
        Assert.assertEquals((Object)this.expectedPerson, (Object)person);
    }

    @Test
    public void testPersistComplexDataWithInputs() throws Exception {
        ArrayList<Hobby> hobbyList = new ArrayList<Hobby>();
        hobbyList.add(new Hobby(ORIGINAL_HOBBY_NAME, ORIGINAL_HOBBY_LEVEL));
        Person originalPerson = new Person(ORIGINAL_NAME, ORIGINAL_SURNAME, ORIGINAL_DATE, new Address(ORIGINAL_STREET, ORIGINAL_NUMBER), hobbyList);
        this.inputs.put("person", originalPerson);
        this.initContext();
        FormStatusData data = this.processor.read("ctxUID");
        Assert.assertNotNull((Object)data);
        Object name = data.getCurrentValue("name");
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)ORIGINAL_NAME, (Object)name);
        Object surname = data.getCurrentValue("surname");
        Assert.assertNotNull((Object)surname);
        Assert.assertEquals((Object)ORIGINAL_SURNAME, (Object)surname);
        Object birthday = data.getCurrentValue("birthday");
        Assert.assertNotNull((Object)birthday);
        Assert.assertEquals((Object)ORIGINAL_DATE, (Object)birthday);
        Object address = data.getCurrentValue("address");
        Assert.assertNotNull((Object)address);
        Assert.assertTrue((boolean)(address instanceof Map));
        Assert.assertFalse((boolean)((Map)address).isEmpty());
        Map addressMap = (Map)address;
        Object street = addressMap.get("street");
        Assert.assertNotNull(street);
        Assert.assertEquals((Object)ORIGINAL_STREET, street);
        Object num = addressMap.get("num");
        Assert.assertNotNull(num);
        Assert.assertEquals((Object)ORIGINAL_NUMBER, num);
        Object hobbies = data.getCurrentValue("hobbies");
        Assert.assertNotNull((Object)hobbies);
        Assert.assertTrue((boolean)(hobbies instanceof Map[]));
        Assert.assertEquals((long)1L, (long)((Map[])hobbies).length);
        Map hobbyMap = ((Map[])hobbies)[0];
        Object hobbyName = hobbyMap.get("name");
        Assert.assertNotNull(hobbyName);
        Assert.assertEquals((Object)ORIGINAL_HOBBY_NAME, hobbyName);
        Object hobbyLevel = hobbyMap.get("level");
        Assert.assertNotNull(hobbyLevel);
        Assert.assertEquals((Object)ORIGINAL_HOBBY_LEVEL, hobbyLevel);
        Mockito.when((Object)this.processor.getFilteredMapRepresentationToPersist(this.context.getForm(), this.context.getUID())).thenReturn((Object)this.generateExpectedValuesMap());
        this.processor.persist("ctxUID");
        Assert.assertNotNull(this.context.getOutputData().get("person"));
        Assert.assertTrue((boolean)(this.context.getOutputData().get("person") instanceof Person));
        Person person = (Person)this.context.getOutputData().get("person");
        Assert.assertEquals((Object)originalPerson, (Object)person);
        Assert.assertEquals((Object)this.expectedPerson, (Object)person);
    }

    protected Map generateExpectedValuesMap() {
        HashMap<String, Object> expectedPersonMap = new HashMap<String, Object>();
        expectedPersonMap.put("name", EXPECTED_NAME);
        expectedPersonMap.put("surname", EXPECTED_SURNAME);
        expectedPersonMap.put("birthday", EXPECTED_DATE);
        HashMap<String, Object> expectedAddress = new HashMap<String, Object>();
        expectedAddress.put("street", EXPECTED_STREET);
        expectedAddress.put("num", EXPECTED_NUMBER);
        expectedPersonMap.put("address", expectedAddress);
        HashMap<String, Object> hobby1 = new HashMap<String, Object>();
        hobby1.put("name", EXPECTED_HOBBY1_NAME);
        hobby1.put("level", EXPECTED_HOBBY1_LEVEL);
        HashMap<String, Object> hobby2 = new HashMap<String, Object>();
        hobby2.put("name", EXPECTED_HOBBY2_NAME);
        hobby2.put("level", EXPECTED_HOBBY2_LEVEL);
        Map[] expectedHobbies = new Map[]{hobby1, hobby2};
        expectedPersonMap.put("hobbies", expectedHobbies);
        return expectedPersonMap;
    }
}

