/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.services.impl.base;

import org.jbpm.form.builder.services.model.FormRepresentation;

public abstract class BaseFormDefinitionService {
    private static final String FORM_ID_PREFIX = "formDefinition_";
    private static final String ITEM_ID_PREFIX = "formItemDefinition_";

    protected boolean updateFormName(FormRepresentation form) {
        if (form.getName() == null || "null".equals(form.getName()) || "".equals(form.getName())) {
            form.setName(FORM_ID_PREFIX + System.currentTimeMillis());
            return false;
        }
        if (!form.getName().startsWith(FORM_ID_PREFIX)) {
            form.setName(FORM_ID_PREFIX + form.getName());
            return false;
        }
        return true;
    }

    protected boolean updateItemName(String formItemName, StringBuilder returnName) {
        if (formItemName == null || "null".equals(formItemName) || "".equals(formItemName)) {
            returnName.append(ITEM_ID_PREFIX).append(System.currentTimeMillis());
            return false;
        }
        if (!formItemName.startsWith(ITEM_ID_PREFIX)) {
            returnName.append(ITEM_ID_PREFIX).append(formItemName);
            return false;
        }
        returnName.append(formItemName);
        return true;
    }

    protected boolean isItemName(String assetId) {
        return assetId.startsWith(ITEM_ID_PREFIX) && assetId.endsWith(".json");
    }

    protected boolean isFormName(String assetId) {
        return assetId.endsWith(".formdef");
    }
}

