/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.util;

import java.util.Date;
import org.jboss.bpm.console.client.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleDateParser {
    private static final String DAY_IN_MONTH = "d";
    private static final String MONTH = "M";
    private static final String YEAR = "y";
    private static final String LITERAL = "\\";
    private static final int DATE_PATTERN = 0;
    private static final int REGEX_PATTERN = 1;
    private static final int COMPONENT = 2;
    private static final int REGEX = 0;
    private static final int INSTRUCTION = 1;
    private static final String[][] TOKENS = new String[][]{{"SSSS", "(\\d\\d\\d\\d)", "S"}, {"SSS", "(\\d\\d\\d)", "S"}, {"SS", "(\\d\\d)", "S"}, {"S", "(\\d)", "S"}, {"ss", "(\\d\\d)", "s"}, {"s", "(\\d)", "s"}, {"mm", "(\\d\\d)", "m"}, {"m", "(\\d)", "m"}, {"HH", "(\\d\\d)", "H"}, {"H", "(\\d)", "H"}, {"dd", "(\\d\\d)", "d"}, {"d", "(\\d)", "d"}, {"MM", "(\\d\\d)", "M"}, {"M", "(\\d)", "M"}, {"yyyy", "(\\d\\d\\d\\d)", "y"}, {"yyy", "(\\d\\d\\d)", "y"}, {"yy", "(\\d\\d)", "y"}, {"y", "(\\d)", "y"}};
    private Pattern regularExpression;
    private String instructions = "";

    private static void _parse(String format, String[] args) {
        if (format.length() == 0) {
            return;
        }
        if (format.startsWith("'")) {
            int end = (format = format.substring(1)).indexOf("'");
            if (end == -1) {
                throw new IllegalArgumentException("Unmatched single quotes.");
            }
            args[0] = args[0] + Pattern.quote((String)format.substring(0, end));
            format = format.substring(end + 1);
        }
        for (int i = 0; i < TOKENS.length; ++i) {
            String[] row = TOKENS[i];
            String datePattern = row[0];
            if (!format.startsWith(datePattern)) continue;
            format = format.substring(datePattern.length());
            args[0] = args[0] + row[1];
            args[1] = args[1] + row[2];
            SimpleDateParser._parse((String)format, (String[])args);
            return;
        }
        args[0] = args[0] + Pattern.quote((String)("" + format.charAt(0)));
        format = format.substring(1);
        SimpleDateParser._parse((String)format, (String[])args);
    }

    private static void load(Date date, String text, String component) {
        if (component.equals("S")) {
            // empty if block
        }
        if (component.equals("s")) {
            date.setSeconds(Integer.parseInt(text));
        }
        if (component.equals("m")) {
            date.setMinutes(Integer.parseInt(text));
        }
        if (component.equals("H")) {
            date.setHours(Integer.parseInt(text));
        }
        if (component.equals("d")) {
            date.setDate(Integer.parseInt(text));
        }
        if (component.equals("M")) {
            date.setMonth(Integer.parseInt(text) - 1);
        }
        if (component.equals("y")) {
            date.setYear(Integer.parseInt(text) - 1900);
        }
    }

    public SimpleDateParser(String format) {
        String[] args = new String[]{"", ""};
        SimpleDateParser._parse((String)format, (String[])args);
        this.regularExpression = new Pattern(args[0]);
        this.instructions = args[1];
    }

    public Date parse(String input) {
        Date date = new Date(0, 0, 1, 0, 0, 0);
        String[] matches = this.regularExpression.match(input);
        if (matches == null) {
            throw new IllegalArgumentException(input + " does not match " + this.regularExpression.pattern());
        }
        if (matches.length - 1 != this.instructions.length()) {
            throw new IllegalArgumentException("Different group count - " + input + " does not match " + this.regularExpression.pattern());
        }
        for (int group = 0; group < this.instructions.length(); ++group) {
            String match = matches[group + 1];
            SimpleDateParser.load((Date)date, (String)match, (String)("" + this.instructions.charAt(group)));
        }
        return date;
    }

    public static Date parse(String input, String pattern) {
        return new SimpleDateParser(pattern).parse(input);
    }
}

