/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fusesource.restygwt.client.Resource;
import org.fusesource.restygwt.client.TextCallback;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.menu.FBMenuItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formbuilder.client.FilesLoadedHandler;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.URLBuilder;
import org.jbpm.formbuilder.client.XmlParseHelper;
import org.jbpm.formbuilder.client.bus.MenuItemAddedEvent;
import org.jbpm.formbuilder.client.bus.MenuItemRemoveEvent;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.shared.form.MockFormDefinitionService;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestyFormBuilderModel
implements FormBuilderService {
    private static final String DEFAULT_PACKAGE = "defaultPackage";
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final XmlParseHelper helper = new XmlParseHelper();
    private final MockFormDefinitionService mockFormService = new MockFormDefinitionService();
    private final String contextPath;
    private String packageName = "defaultPackage";

    public RestyFormBuilderModel(String contextPath) {
        this.contextPath = contextPath;
        this.bus.addHandler(MenuItemAddedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(MenuItemRemoveEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void getMenuItems() {
        Resource resource = new Resource(URLBuilder.getMenuItemsURL((String)this.contextPath));
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getCurrentRoles(FormBuilderService.RolesResponseHandler handler) {
        Resource resource = new Resource(URLBuilder.getCurrentRolesURL((String)this.contextPath));
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void logout() {
        Resource resource = new Resource(URLBuilder.getLogoutURL((String)this.contextPath));
        resource.post().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getMenuOptions() {
        Resource resource = new Resource(URLBuilder.getMenuOptionsURL((String)this.contextPath));
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void saveForm(FormRepresentation form) {
        Resource resource = new Resource(URLBuilder.saveFormURL((String)this.contextPath, (String)this.packageName));
        try {
            String json = FormEncodingFactory.getEncoder().encode(form);
            resource.post().text(json).send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (FormEncodingException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.CouldntDecodeForm(), (Throwable)e));
        }
    }

    public void saveFormItem(FormItemRepresentation formItem, String formItemName) {
        Resource resource = new Resource(URLBuilder.saveFormItemURL((String)this.contextPath, (String)this.packageName, (String)formItemName));
        try {
            String xml = this.helper.asXml(formItemName, formItem);
            resource.post().xml(XMLParser.parse((String)xml)).send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (FormEncodingException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.CouldntDecodeFormItem(formItemName), (Throwable)e));
        }
    }

    public void deleteForm(FormRepresentation form) {
        Resource resource = new Resource(URLBuilder.deleteFormURL((String)this.contextPath, (String)this.packageName, (String)form.getName()));
        try {
            resource.delete().send((RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.ErrorDeletingForm(""), (Throwable)e));
        }
    }

    public void deleteFile(String url) throws FormBuilderException {
        Resource resource = new Resource(URLBuilder.deleteFileURL((String)this.contextPath, (String)this.packageName, (String)url));
        try {
            resource.delete().send((RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.ErrorDeletingForm(""), (Throwable)e));
        }
    }

    public void getFiles(List<String> types, FilesLoadedHandler handler) {
        String url = URLBuilder.getFilesURL((String)this.contextPath, (String)this.packageName, types);
        Resource resource = new Resource(url);
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteFormItem(String formItemName, FormItemRepresentation formItem) {
        Resource resource = new Resource(URLBuilder.deleteFormItemURL((String)this.contextPath, (String)this.packageName, (String)formItemName));
        try {
            resource.delete().send((RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.ErrorDeletingFormItem(""), (Throwable)e));
        }
    }

    public void generateForm(FormRepresentation form, String language, Map<String, Object> inputs) {
        Resource resource = new Resource(URLBuilder.generateFormURL((String)this.contextPath, (String)language));
        try {
            String xml = this.helper.asXml(form, inputs);
            resource.post().header("Accept", "text/plain").xml(XMLParser.parse((String)xml)).send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (FormEncodingException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.CouldntDecodeForm(), (Throwable)e));
        }
    }

    public void saveMenuItem(String groupName, FBMenuItem item) {
        Resource resource = new Resource(URLBuilder.getMenuItemsURL((String)this.contextPath));
        String xml = this.helper.asXml(groupName, item);
        try {
            resource.post().xml(XMLParser.parse((String)xml)).expect(new int[]{201, 409}).send((RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.CouldntSaveMenuItem(), (Throwable)e));
        }
    }

    public void deleteMenuItem(String groupName, FBMenuItem item) {
        Resource resource = new Resource(URLBuilder.getMenuItemsURL((String)this.contextPath));
        String xml = this.helper.asXml(groupName, item);
        try {
            resource.delete().xml(XMLParser.parse((String)xml)).send((RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.ErrorDeletingMenuItem(), (Throwable)e));
        }
    }

    public void getExistingIoAssociations(String filter) {
        String url = URLBuilder.getIoAssociationsURL((String)this.contextPath, (String)this.packageName);
        Resource resource = new Resource(url);
        if (filter != null && !"".equals(filter)) {
            resource = resource.addQueryParam("q", filter);
        }
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void selectIoAssociation(String pkgName, String processName, String taskName) {
        String url = URLBuilder.getIoAssociationURL((String)this.contextPath, (String)pkgName, (String)processName, (String)taskName);
        Resource resource = new Resource(url);
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getExistingValidations() {
        Resource resource = new Resource(URLBuilder.getValidationsURL((String)this.contextPath));
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getForm(String formName) {
        String url = URLBuilder.getFormURL((String)this.contextPath, (String)this.packageName, (String)formName);
        Resource resource = new Resource(url);
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getForms() {
        String url = URLBuilder.getFormsURL((String)this.contextPath, (String)this.packageName);
        Resource resource = new Resource(url);
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void populateRepresentationFactory() {
        String url = URLBuilder.getRepresentationMappingsURL((String)this.contextPath);
        Resource resource = new Resource(url);
        resource.get().send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void loadFormTemplate(FormRepresentation form, String language) {
        String url = URLBuilder.loadFormTemplateURL((String)this.contextPath, (String)language);
        Resource resource = new Resource(url);
        try {
            String xml = this.helper.asXml(form, null);
            resource.post().xml(XMLParser.parse((String)xml)).send((TextCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (FormEncodingException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.CouldntDecodeForm(), (Throwable)e));
        }
    }

    public FormRepresentation toBasicForm(TaskRef task) {
        return this.mockFormService.createFormFromTask(task);
    }

    public String getUploadFileURL() {
        return URLBuilder.uploadFileURL((String)this.contextPath, (String)this.packageName);
    }

    public String getUploadActionURL() {
        return URLBuilder.uploadActionURL();
    }

    private void populateMockFormService(FBMenuItem item) {
        String className = item.getClass().getName();
        ArrayList<String> effectClassNames = new ArrayList<String>();
        if (item.getFormEffects() != null) {
            for (FBFormEffect effect : item.getFormEffects()) {
                effectClassNames.add(effect.getClass().getName());
            }
        }
        if (item.getAllowedEvents() != null) {
            this.mockFormService.putActionsForItem(className, item.getAllowedEvents());
        }
        this.mockFormService.putEffectsForItem(className, effectClassNames);
    }

    static /* synthetic */ XmlParseHelper access$000(RestyFormBuilderModel x0) {
        return x0.helper;
    }

    static /* synthetic */ void access$100(RestyFormBuilderModel x0, FBMenuItem x1) {
        x0.populateMockFormService(x1);
    }

    static /* synthetic */ EventBus access$200(RestyFormBuilderModel x0) {
        return x0.bus;
    }

    static /* synthetic */ I18NConstants access$300(RestyFormBuilderModel x0) {
        return x0.i18n;
    }
}

