/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.view;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.formapi.client.validation.FBValidationItem;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.effect.view.ValidationTablePanel;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationTablePanel
extends VerticalPanel
implements HasSelectionHandlers<FBValidationItem> {
    private List<SelectionHandler<FBValidationItem>> tableHandlers = new ArrayList();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final Grid validationsTable = new Grid(1, 4);
    private final List<FBValidationItem> currentValidations = new ArrayList();
    private FBValidationItem selectedValidation = null;

    public ValidationTablePanel() {
        this.validationsTable.setWidget(0, 0, (Widget)new HTML("<strong>" + this.i18n.CurrentValidations() + "</strong>"));
        this.validationsTable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this.validationsTable);
    }

    public void setCurrentValidation(FBValidationItem validation) {
        this.selectedValidation = validation;
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<FBValidationItem> handler) {
        2 handlerRegistration = new /* Unavailable Anonymous Inner Class!! */;
        if (!this.tableHandlers.contains(handler)) {
            this.tableHandlers.add(handler);
        }
        return handlerRegistration;
    }

    public void fireEvent(GwtEvent<?> event) {
        for (SelectionHandler handler : this.tableHandlers) {
            handler.onSelection((SelectionEvent)event);
        }
    }

    protected void fireSelectedValidation() {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)this.selectedValidation);
    }

    public void addValidation(FBValidationItem validation) {
        if (!this.currentValidations.contains(validation)) {
            int rowCount = this.validationsTable.getRowCount();
            this.validationsTable.resizeRows(rowCount + 1);
            this.validationsTable.setWidget(rowCount, 0, (Widget)new Label(validation.getName()));
            Image upLink = new Image(FormBuilderResources.INSTANCE.arrowUp());
            upLink.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            Image downLink = new Image(FormBuilderResources.INSTANCE.arrowDown());
            downLink.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            Image removeLink = new Image(FormBuilderResources.INSTANCE.removeSmallIcon());
            removeLink.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            removeLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            upLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            downLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.validationsTable.setWidget(rowCount, 1, (Widget)upLink);
            this.validationsTable.setWidget(rowCount, 2, (Widget)downLink);
            this.validationsTable.setWidget(rowCount, 3, (Widget)removeLink);
            this.currentValidations.add(validation);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
    }

    public int getSelectedRow(ClickEvent event) {
        return this.validationsTable.getCellForEvent(event).getRowIndex();
    }

    public void removeValidation(FBValidationItem validation, int row) {
        if (row >= 0) {
            this.currentValidations.remove(validation);
            this.validationsTable.removeRow(row);
        }
    }

    public void moveSelectedValidation(boolean up) {
        int index = this.currentValidations.indexOf(this.selectedValidation);
        if (index >= 0) {
            if (up && index + 1 < this.currentValidations.size()) {
                FBValidationItem supValidation = (FBValidationItem)this.currentValidations.get(index + 1);
                this.currentValidations.set(index + 1, this.selectedValidation);
                this.currentValidations.set(index, supValidation);
            } else if (!up && index - 1 > 0) {
                FBValidationItem subValidation = (FBValidationItem)this.currentValidations.get(index - 1);
                this.currentValidations.set(index - 1, this.selectedValidation);
                this.currentValidations.set(index, subValidation);
            }
            this.moveValidationOnTable(index, up);
        }
    }

    private void moveValidationOnTable(int index, boolean up) {
        block3: {
            block2: {
                if (!up || index + 2 >= this.validationsTable.getRowCount()) break block2;
                for (int i = 0; i < this.validationsTable.getColumnCount(); ++i) {
                    Widget move = this.validationsTable.getWidget(index + 1, i);
                    Widget res = this.validationsTable.getWidget(index + 2, i);
                    this.validationsTable.remove(move);
                    this.validationsTable.remove(res);
                    this.validationsTable.setWidget(index + 1, i, res);
                    this.validationsTable.setWidget(index + 2, i, move);
                }
                break block3;
            }
            if (up || index <= 0) break block3;
            for (int i = 0; i < this.validationsTable.getColumnCount(); ++i) {
                Widget move = this.validationsTable.getWidget(index + 1, i);
                Widget res = this.validationsTable.getWidget(index, i);
                this.validationsTable.remove(move);
                this.validationsTable.remove(res);
                this.validationsTable.setWidget(index + 1, i, res);
                this.validationsTable.setWidget(index, i, move);
            }
        }
    }

    public List<FBValidationItem> getCurrentValidations() {
        return this.currentValidations;
    }

    static /* synthetic */ Grid access$000(ValidationTablePanel x0) {
        return x0.validationsTable;
    }

    static /* synthetic */ List access$100(ValidationTablePanel x0) {
        return x0.currentValidations;
    }

    static /* synthetic */ List access$200(ValidationTablePanel x0) {
        return x0.tableHandlers;
    }
}

