/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.BorderPanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.items.BorderLayoutFormItem;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class BorderLayoutFormItem
extends LayoutFormItem {
    private EventBus bus = CommonGlobals.getInstance().getEventBus();
    private I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private Map<BorderPanelRepresentation.Position, FBFormItem> locations = new HashMap();
    private BorderPanelRepresentation.Position currentPosition = null;
    private Grid grid = new /* Unavailable Anonymous Inner Class!! */;

    public BorderLayoutFormItem() {
        this(new ArrayList());
    }

    public BorderLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.grid);
        this.grid.setSize("180px", "180px");
        this.setSize("180px", "180px");
    }

    protected void setDropPosition(BorderPanelRepresentation.Position position) {
        this.currentPosition = position;
    }

    protected BorderPanelRepresentation.Position obtainPosition(int x, int y) {
        boolean top;
        int xpos = x - this.grid.getAbsoluteLeft();
        int width = this.grid.getOffsetWidth();
        int ypos = y - this.grid.getAbsoluteTop();
        int height = this.grid.getOffsetHeight();
        boolean left = width / 3 > xpos;
        boolean right = width * 2 / 3 < xpos;
        boolean bottom = height * 2 / 3 < ypos;
        boolean bl = top = height / 3 > ypos;
        if (!(left || right || bottom || top)) {
            return BorderPanelRepresentation.Position.CENTER;
        }
        if (!left && !right && top) {
            return BorderPanelRepresentation.Position.NORTH;
        }
        if (!left && !right && bottom) {
            return BorderPanelRepresentation.Position.SOUTH;
        }
        if (!bottom && !top && right) {
            return BorderPanelRepresentation.Position.EAST;
        }
        if (!bottom && !top && left) {
            return BorderPanelRepresentation.Position.WEST;
        }
        if (top && right) {
            return BorderPanelRepresentation.Position.NORTHEAST;
        }
        if (bottom && right) {
            return BorderPanelRepresentation.Position.SOUTHEAST;
        }
        if (top && left) {
            return BorderPanelRepresentation.Position.NORTHWEST;
        }
        if (bottom && left) {
            return BorderPanelRepresentation.Position.SOUTHWEST;
        }
        return null;
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.populate(this.grid);
    }

    private void populate(Grid myGrid) {
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            this.grid.setHeight(this.getHeight());
        }
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            this.grid.setWidth(this.getWidth());
        }
    }

    public FormItemRepresentation getRepresentation() {
        BorderPanelRepresentation rep = (BorderPanelRepresentation)super.getRepresentation((FormItemRepresentation)new BorderPanelRepresentation());
        for (Map.Entry entry : this.locations.entrySet()) {
            BorderPanelRepresentation.Position key = (BorderPanelRepresentation.Position)entry.getKey();
            FormItemRepresentation value = ((FBFormItem)entry.getValue()).getRepresentation();
            rep.putItem(key, value);
        }
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof BorderPanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "BorderPanelRepresentation"));
        }
        super.populate(rep);
        BorderPanelRepresentation brep = (BorderPanelRepresentation)rep;
        Map repItems = brep.getItems();
        if (repItems != null) {
            for (Map.Entry entry : repItems.entrySet()) {
                BorderPanelRepresentation.Position key = (BorderPanelRepresentation.Position)entry.getKey();
                FBFormItem value = LayoutFormItem.createItem((FormItemRepresentation)((FormItemRepresentation)entry.getValue()));
                this.currentPosition = key;
                this.add(value);
            }
        }
    }

    public FBFormItem cloneItem() {
        BorderLayoutFormItem clone = (BorderLayoutFormItem)super.cloneItem((FBFormItem)new BorderLayoutFormItem(this.getFormEffects()));
        clone.currentPosition = this.currentPosition;
        clone.grid = (Grid)this.cloneDisplay(null);
        clone.locations = new HashMap(this.locations);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        int rows = this.grid.getRowCount();
        int columns = this.grid.getColumnCount();
        Grid g = new Grid(rows, columns);
        this.populate(g);
        for (int index = 0; index < columns * rows; ++index) {
            int row = index / columns;
            int column = index % columns;
            FBFormItem item = (FBFormItem)this.grid.getWidget(row, column);
            if (item == null) continue;
            g.setWidget(row, column, item.cloneDisplay(data));
        }
        super.populateActions(g.getElement());
        return g;
    }

    public HasWidgets getPanel() {
        return this.grid;
    }

    private int getRow(BorderPanelRepresentation.Position pos) {
        int row = 0;
        switch (2.$SwitchMap$org$jbpm$formapi$shared$api$items$BorderPanelRepresentation$Position[pos.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.ensureRows();
                row = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.ensureRows();
                row = 2;
                break;
            }
            default: {
                row = this.getMiddleRow();
            }
        }
        return row;
    }

    private int getColumn(BorderPanelRepresentation.Position pos) {
        int col = 0;
        switch (2.$SwitchMap$org$jbpm$formapi$shared$api$items$BorderPanelRepresentation$Position[pos.ordinal()]) {
            case 2: 
            case 5: 
            case 7: {
                this.ensureColumns();
                col = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                this.ensureColumns();
                col = 0;
                break;
            }
            default: {
                col = this.getMiddleColumn();
            }
        }
        return col;
    }

    public boolean add(FBFormItem item) {
        this.currentPosition = this.obtainPosition(item.getDesiredX(), item.getDesiredY());
        int row = this.getRow(this.currentPosition);
        int col = this.getColumn(this.currentPosition);
        if (this.locations.get(this.currentPosition) == null) {
            this.grid.setWidget(row, col, (Widget)item);
            this.locations.put(this.currentPosition, item);
            this.currentPosition = null;
            return super.add(item);
        }
        this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.BorderLayoutPositionPopulated()));
        return false;
    }

    public void add(PhantomPanel phantom, int x, int y) {
        BorderPanelRepresentation.Position pos = this.obtainPosition(x, y);
        if (this.locations.get(pos) == null) {
            this.grid.setWidget(this.getRow(pos), this.getColumn(pos), (Widget)phantom);
        }
    }

    public void replacePhantom(FBFormItem item) {
        this.currentPosition = this.obtainPosition(item.getDesiredX(), item.getDesiredY());
        int row = this.getRow(this.currentPosition);
        int col = this.getColumn(this.currentPosition);
        if (this.locations.get(this.currentPosition) == null) {
            this.grid.setWidget(row, col, (Widget)item);
            this.locations.put(this.currentPosition, item);
            this.currentPosition = null;
            super.add(item);
        } else {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.BorderLayoutPositionPopulated()));
        }
    }

    private int getMiddleRow() {
        int row = 0;
        if (this.grid.getRowCount() == 3) {
            row = 1;
        }
        return row;
    }

    private int getMiddleColumn() {
        int col = 0;
        if (this.grid.getColumnCount() == 3) {
            col = 1;
        }
        return col;
    }

    private void ensureRows() {
        if (this.grid.getRowCount() < 3) {
            this.grid.resizeRows(3);
            for (int i = 0; i < 2; ++i) {
                Widget widget;
                if (this.grid.getColumnCount() <= i || (widget = this.grid.getWidget(0, i)) == null) continue;
                this.grid.remove(widget);
                this.grid.setWidget(1, i, widget);
            }
            this.grid.setSize(this.getWidth(), this.getHeight());
        }
    }

    private void ensureColumns() {
        if (this.grid.getColumnCount() < 3) {
            this.grid.resizeColumns(3);
            for (int i = 0; i < 2; ++i) {
                Widget widget;
                if (this.grid.getRowCount() <= i || (widget = this.grid.getWidget(i, 0)) == null) continue;
                this.grid.remove(widget);
                this.grid.setWidget(i, 1, widget);
            }
            this.grid.setSize(this.getWidth(), this.getHeight());
        }
    }

    public boolean remove(Widget child) {
        boolean removed = false;
        if (child instanceof FBFormItem) {
            BorderPanelRepresentation.Position pos = null;
            for (Map.Entry entry : this.locations.entrySet()) {
                if (!((FBFormItem)entry.getValue()).equals(child)) continue;
                pos = (BorderPanelRepresentation.Position)entry.getKey();
                break;
            }
            this.locations.remove(pos);
            this.removeItem((FBFormItem)child);
        } else {
            removed = super.remove(child);
        }
        return removed;
    }
}

