/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.TableRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class TableLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private Grid grid = new /* Unavailable Anonymous Inner Class!! */;
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private Integer borderWidth = 1;
    private Integer cellpadding = null;
    private Integer cellspacing = null;
    private Integer columns = 1;
    private Integer rows = 1;
    private String title = null;

    public TableLayoutFormItem() {
        this(new ArrayList());
    }

    public TableLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.grid.setBorderWidth(this.borderWidth.intValue());
        this.add((Widget)this.grid);
        this.setSize("90px", "90px");
        this.grid.setSize(this.getWidth(), this.getHeight());
    }

    public HasWidgets getPanel() {
        return this.grid;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.borderWidth = this.extractInt(asPropertiesMap.get("borderWidth"));
        this.cellpadding = this.extractInt(asPropertiesMap.get("cellpadding"));
        this.cellspacing = this.extractInt(asPropertiesMap.get("cellspacing"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.columns = this.extractInt(asPropertiesMap.get("columns"));
        this.rows = this.extractInt(asPropertiesMap.get("rows"));
        this.populate(this.grid);
    }

    private void populate(Grid grid) {
        if (this.borderWidth != null && this.borderWidth > 0) {
            grid.setBorderWidth(this.borderWidth.intValue());
        }
        if (this.cellpadding != null && this.cellpadding >= 0) {
            grid.setCellPadding(this.cellpadding.intValue());
        }
        if (this.cellspacing != null && this.cellspacing >= 0) {
            grid.setCellSpacing(this.cellspacing.intValue());
        }
        if (this.getHeight() != null) {
            grid.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            grid.setWidth(this.getWidth());
        }
        if (this.title != null) {
            grid.setTitle(this.title);
        }
        if (this.columns != null && this.columns > 0) {
            grid.resizeColumns(this.columns.intValue());
        }
        if (this.rows != null && this.rows > 0) {
            grid.resizeRows(this.rows.intValue());
        }
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("borderWidth", this.borderWidth);
        map.put("cellpadding", this.cellpadding);
        map.put("cellspacing", this.cellspacing);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("title", this.title);
        map.put("columns", this.columns);
        map.put("rows", this.rows);
        return map;
    }

    public boolean add(FBFormItem child) {
        boolean added = false;
        block0: for (int i = 0; i < this.grid.getRowCount() && !added; ++i) {
            for (int j = 0; j < this.grid.getColumnCount() && !added; ++j) {
                if (this.grid.getWidget(i, j) != null && !this.isWhiteSpace(this.grid.getWidget(i, j))) continue;
                added = true;
                int index = i * this.grid.getColumnCount() + j;
                if (super.size() > index) {
                    super.insert(index - 1, child);
                } else {
                    super.add(child);
                }
                this.grid.setWidget(i, j, (Widget)child);
                continue block0;
            }
        }
        if (!added) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.TableFull()));
            return false;
        }
        return true;
    }

    public void add(PhantomPanel phantom, int x, int y) {
        int row = 0;
        int column = 0;
        boolean found = false;
        while (row < this.grid.getRowCount() && !found) {
            for (column = 0; column < this.grid.getColumnCount() && !found; ++column) {
                Element cellElement = this.grid.getCellFormatter().getElement(row, column);
                if (x <= cellElement.getAbsoluteLeft() || x >= cellElement.getAbsoluteRight() || y <= cellElement.getAbsoluteTop() || y >= cellElement.getAbsoluteBottom() || this.grid.getWidget(row, column) != null && !this.isWhiteSpace(this.grid.getWidget(row, column)) && !this.isPhantom(this.grid.getWidget(row, column))) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++row;
        }
        if (found && !this.isPhantom(this.grid.getWidget(row, column))) {
            this.grid.setWidget(row, column, (Widget)phantom);
        }
    }

    public int getRowForYCoordinate(int y) {
        for (int row = 0; row < this.grid.getRowCount(); ++row) {
            Element rowElement = this.grid.getRowFormatter().getElement(row);
            if (y <= rowElement.getAbsoluteTop() || y >= rowElement.getAbsoluteBottom()) continue;
            return row;
        }
        return -1;
    }

    public List<FBFormItem> removeRow(int rowNumber) {
        ArrayList<FBFormItem> retval = null;
        if (rowNumber < this.grid.getRowCount()) {
            retval = new ArrayList<FBFormItem>(this.grid.getColumnCount());
            for (int column = 0; column < this.grid.getColumnCount(); ++column) {
                Widget widget = this.grid.getWidget(rowNumber, column);
                if (widget instanceof FBFormItem) {
                    retval.add((FBFormItem)widget);
                } else {
                    retval.add(null);
                }
                this.grid.remove(widget);
            }
            this.grid.removeRow(rowNumber);
            TableLayoutFormItem tableLayoutFormItem = this;
            Integer n = tableLayoutFormItem.rows;
            Integer n2 = tableLayoutFormItem.rows = Integer.valueOf(tableLayoutFormItem.rows - 1);
        }
        return retval;
    }

    public void addRow(int beforeRowNumber) {
        this.grid.insertRow(beforeRowNumber);
        TableLayoutFormItem tableLayoutFormItem = this;
        Integer n = tableLayoutFormItem.rows;
        Integer n2 = tableLayoutFormItem.rows = Integer.valueOf(tableLayoutFormItem.rows + 1);
    }

    public void insertRowElements(int rowNumber, List<FBFormItem> rowItems) {
        FBFormItem prevItem = null;
        for (int i = rowNumber - 1; i > 0 && prevItem == null; --i) {
            for (int j = this.grid.getColumnCount(); j > 0 && prevItem == null; --j) {
                Widget widget = this.grid.getWidget(i, j);
                if (widget == null || !(widget instanceof FBFormItem)) continue;
                prevItem = (FBFormItem)widget;
            }
        }
        int index = prevItem == null ? -1 : super.getItems().indexOf(prevItem);
        int colNumber = 0;
        for (FBFormItem newItem : rowItems) {
            if (newItem != null) {
                if (index < 0) {
                    super.add(newItem);
                } else {
                    super.insert(index, newItem);
                }
                ++index;
                this.grid.setWidget(rowNumber, colNumber, (Widget)newItem);
            }
            ++colNumber;
        }
    }

    public void insertColumnElements(int colNumber, List<FBFormItem> columnItems) {
        int rowNumber = 0;
        for (FBFormItem newItem : columnItems) {
            int index;
            FBFormItem prevItem = null;
            for (int i = this.grid.getRowCount(); i > 0 && prevItem == null; --i) {
                for (int j = colNumber - 1; j > 0 && prevItem == null; --j) {
                    Widget widget = this.grid.getWidget(i, j);
                    if (widget == null || !(widget instanceof FBFormItem)) continue;
                    prevItem = (FBFormItem)widget;
                }
            }
            int n = index = prevItem == null ? -1 : super.getItems().indexOf(prevItem);
            if (newItem != null) {
                if (index < 0) {
                    super.add(newItem);
                } else {
                    super.insert(index, newItem);
                }
                this.grid.setWidget(rowNumber, colNumber, (Widget)newItem);
            }
            ++rowNumber;
        }
    }

    public int getColumnForXCoordinate(int x) {
        if (this.grid.getRowCount() > 0) {
            for (int column = 0; column < this.grid.getColumnCount(); ++column) {
                Element cellElement = this.grid.getCellFormatter().getElement(0, column);
                if (x <= cellElement.getAbsoluteLeft() || x >= cellElement.getAbsoluteRight()) continue;
                return column;
            }
        }
        return -1;
    }

    public void addColumn(int beforeColumnNumber) {
        if (beforeColumnNumber < this.grid.getColumnCount()) {
            TableLayoutFormItem tableLayoutFormItem = this;
            Integer n = tableLayoutFormItem.columns;
            Integer n2 = tableLayoutFormItem.columns = Integer.valueOf(tableLayoutFormItem.columns + 1);
            this.grid.resizeColumns(this.grid.getColumnCount() + 1);
            for (int row = 0; row < this.grid.getRowCount(); ++row) {
                for (int column = this.grid.getColumnCount() - 1; column > beforeColumnNumber && column < this.grid.getColumnCount(); ++column) {
                    Widget widget;
                    if (column <= 0 || (widget = this.grid.getWidget(row, column - 1)) == null) continue;
                    this.grid.setWidget(row, column, widget);
                    if (this.grid.getWidget(row, column - 1) == null) continue;
                    this.grid.getWidget(row, column - 1).getElement().getParentElement().setInnerHTML("&nbsp;");
                }
            }
        }
    }

    public List<FBFormItem> removeColumn(int columnNumber) {
        ArrayList<FBFormItem> retval = null;
        if (columnNumber < this.grid.getColumnCount()) {
            retval = new ArrayList<FBFormItem>(this.grid.getRowCount());
            for (int row = 0; row < this.grid.getRowCount(); ++row) {
                for (int column = columnNumber + 1; column < this.grid.getColumnCount(); ++column) {
                    Widget widget = this.grid.getWidget(row, column);
                    if (column == columnNumber + 1 && widget instanceof FBFormItem) {
                        retval.add((FBFormItem)widget);
                    } else if (column == columnNumber + 1) {
                        retval.add(null);
                    }
                    this.grid.setWidget(row, column - 1, widget);
                    this.remove(widget);
                }
            }
            this.grid.resizeColumns(this.grid.getColumnCount() - 1);
            TableLayoutFormItem tableLayoutFormItem = this;
            Integer n = tableLayoutFormItem.columns;
            Integer n2 = tableLayoutFormItem.columns = Integer.valueOf(tableLayoutFormItem.columns - 1);
        }
        return retval;
    }

    protected boolean isPhantom(Widget widget) {
        return widget != null && widget instanceof PhantomPanel;
    }

    public void replacePhantom(FBFormItem item) {
        int row;
        boolean found = false;
        int column = 0;
        for (row = 0; row < this.grid.getRowCount(); ++row) {
            for (column = 0; column < this.grid.getColumnCount() && !found; ++column) {
                if (!this.isPhantom(this.grid.getWidget(row, column))) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (found) {
            int index = row * this.grid.getColumnCount() + column;
            if (super.size() > index) {
                super.insert(index, item);
            } else {
                super.add(item);
            }
            this.grid.setWidget(row, column, null);
            this.grid.setWidget(row, column, (Widget)item);
        } else {
            this.add(item);
        }
    }

    public boolean removeItem(FBFormItem item) {
        return false;
    }

    public FormItemRepresentation getRepresentation() {
        TableRepresentation rep = (TableRepresentation)super.getRepresentation((FormItemRepresentation)new TableRepresentation());
        rep.setRows(this.rows);
        rep.setColumns(this.columns);
        rep.setBorderWidth(this.borderWidth);
        rep.setCellPadding(this.cellpadding);
        rep.setCellSpacing(this.cellspacing);
        for (int index = 0; index < this.columns * this.rows; ++index) {
            int column = index % this.columns;
            int row = index / this.columns;
            Widget widget = this.grid.getWidget(row, column);
            if (widget == null || !(widget instanceof FBFormItem)) continue;
            FBFormItem item = (FBFormItem)widget;
            FormItemRepresentation subRep = item.getRepresentation();
            rep.setElement(row, column, subRep);
        }
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof TableRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "TableRepresentation"));
        }
        super.populate(rep);
        TableRepresentation trep = (TableRepresentation)rep;
        this.rows = trep.getRows();
        this.columns = trep.getColumns();
        this.borderWidth = trep.getBorderWidth();
        this.cellpadding = trep.getCellPadding();
        this.cellspacing = trep.getCellSpacing();
        this.populate(this.grid);
        this.grid.clear();
        super.getItems().clear();
        if (trep.getWidth() != null) {
            this.setWidth(trep.getWidth());
        }
        if (trep.getHeight() != null) {
            this.setHeight(trep.getHeight());
        }
        if (trep.getElements() != null) {
            for (int rowindex = 0; rowindex < trep.getElements().size(); ++rowindex) {
                List row = (List)trep.getElements().get(rowindex);
                if (row == null) continue;
                for (int cellindex = 0; cellindex < row.size(); ++cellindex) {
                    FormItemRepresentation cell = (FormItemRepresentation)row.get(cellindex);
                    FBFormItem subItem = LayoutFormItem.createItem((FormItemRepresentation)cell);
                    this.grid.setWidget(rowindex, cellindex, (Widget)subItem);
                    super.add(subItem);
                }
            }
        }
    }

    private void addItemToCollection(FBFormItem item) {
        super.add(item);
    }

    public FBFormItem cloneItem() {
        TableLayoutFormItem clone = new TableLayoutFormItem(this.getFormEffects());
        clone.borderWidth = this.borderWidth;
        clone.cellpadding = this.cellpadding;
        clone.cellspacing = this.cellspacing;
        clone.columns = this.columns;
        clone.setHeight(this.getHeight());
        clone.rows = this.rows;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.grid);
        for (int index = 0; index < clone.columns * clone.rows; ++index) {
            int column = index % clone.columns;
            int row = index / clone.columns;
            FBFormItem item = (FBFormItem)this.grid.getWidget(row, column);
            if (item == null) continue;
            clone.grid.setWidget(row, column, (Widget)item.cloneItem());
        }
        List items = this.getItems();
        if (items != null) {
            for (FBFormItem item : items) {
                clone.addItemToCollection(item);
            }
        }
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        Grid g = new Grid(this.rows.intValue(), this.columns.intValue());
        this.populate(g);
        for (int index = 0; index < this.columns * this.rows; ++index) {
            int column = index % this.columns;
            int row = index / this.columns;
            FBFormItem item = (FBFormItem)this.grid.getWidget(row, column);
            if (item == null) continue;
            g.setWidget(row, column, item.cloneDisplay(data));
        }
        super.populateActions(g.getElement());
        return g;
    }
}

