/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.tasks;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.tasks.IoAssociationView;
import org.jbpm.formbuilder.client.tasks.TaskRow;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultsView
extends VerticalPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final IoAssociationView.Presenter presenter;

    public SearchResultsView(IoAssociationView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setTasks(List<TaskRef> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            this.clear();
            this.add((Widget)new Label(this.i18n.NoIoRefsFound()));
        } else {
            this.clear();
            boolean even = false;
            for (TaskRef task : tasks) {
                TaskRow row = this.presenter.newTaskRow(task, even);
                even = !even;
                this.add((Widget)row);
            }
        }
    }

    public void setSelectedTask(TaskRef selectedTask) {
        if (selectedTask != null) {
            TaskRow selectedRow = null;
            for (Widget widget : this) {
                TaskRow row = (TaskRow)widget;
                if (!row.getIoRef().equals((Object)selectedTask)) continue;
                selectedRow = row;
                break;
            }
            this.clear();
            if (selectedRow == null) {
                selectedRow = new TaskRow(selectedTask, true);
            }
            selectedRow.getFocus().removeHandler();
            selectedRow.getBlur().removeHandler();
            selectedRow.showInputs();
            selectedRow.showOutputs();
            selectedRow.showMetaData();
            selectedRow.clearRightClickHandlers();
            this.presenter.addQuickFormHandling(selectedRow);
            this.add((Widget)selectedRow);
        }
    }
}

