/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.shared.task;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.formbuilder.shared.task.TaskDefinitionService;
import org.jbpm.formbuilder.shared.task.TaskRef;
import org.jbpm.formbuilder.shared.task.TaskServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockTaskDefinitionService
implements TaskDefinitionService {
    private List<TaskRef> tasks = new ArrayList();

    public MockTaskDefinitionService() {
        TaskRef task1 = new TaskRef();
        task1.setTaskId("task1");
        task1.addInput("input1", "${hey}");
        task1.addInput("input2", "${why}");
        task1.addOutput("output1", "");
        task1.addOutput("output2", "");
        this.tasks.add(task1);
        TaskRef task2 = new TaskRef();
        task2.setTaskId("task2");
        task2.addInput("input3", "${hey}");
        task2.addInput("input4", "${why}");
        task2.addOutput("output3", "");
        task2.addOutput("output4", "");
        this.tasks.add(task2);
    }

    public List<TaskRef> query(String pkgName, String filter) {
        return new ArrayList<TaskRef>(this.tasks);
    }

    public List<TaskRef> getTasksByName(String pkgName, String processName, String taskName) {
        return this.tasks.subList(0, 1);
    }

    public TaskRef getTaskByUUID(String pkgName, String userTask, String uuid) throws TaskServiceException {
        TaskRef retval = null;
        for (TaskRef task : this.tasks) {
            if (!task.getTaskId().equals(userTask)) continue;
            retval = task;
            break;
        }
        return retval;
    }

    public String getContainingPackage(String uuid) throws TaskServiceException {
        return "defaultPackage";
    }

    public TaskRef getBPMN2Task(String bpmn2ProcessContent, String processName, String userTask) throws TaskServiceException {
        return this.getTaskByUUID(null, userTask, null);
    }
}

