/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.command;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.HashMap;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationEvent;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationResponseEvent;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.bus.UndoableHandler;
import org.jbpm.formbuilder.client.command.BaseCommand;
import org.jbpm.formbuilder.client.messages.I18NConstants;

@Reflectable
public class DeleteFormCommand
implements BaseCommand {
    private static final String DELETE_TYPE = DeleteFormCommand.class.getName();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final FormBuilderService service = FormBuilderGlobals.getInstance().getService();
    private MenuItem item = null;

    public DeleteFormCommand() {
        this.bus.addHandler(GetFormRepresentationResponseEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void execute() {
        this.bus.fireEvent((GwtEvent)new GetFormRepresentationEvent(DELETE_TYPE));
    }

    public void setItem(MenuItem item) {
        this.item = item;
        item.setEnabled(true);
    }

    public void setEmbeded(String profile) {
        if (profile != null && "guvnor".equals(profile) && this.item != null) {
            this.item.getParentMenu().removeItem(this.item);
        }
    }

    private void showDeletePanel(FormRepresentation form) {
        VerticalPanel vpanel;
        PopupPanel panel = new PopupPanel();
        if (form.isSaved()) {
            vpanel = new VerticalPanel();
            vpanel.add((Widget)new Label(this.i18n.WarningDeleteForm(form.getName())));
            HorizontalPanel hpanel = new HorizontalPanel();
            Button confirmButton = new Button(this.i18n.ConfirmButton());
            confirmButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)confirmButton);
            Button cancelButton = new Button(this.i18n.CancelButton());
            cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)cancelButton);
            vpanel.add((Widget)hpanel);
            panel.setWidget((Widget)vpanel);
        } else {
            vpanel = new VerticalPanel();
            vpanel.add((Widget)new Label(this.i18n.FormWasNeverSaved()));
            Button closeButton = new Button(this.i18n.CloseButton());
            closeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            vpanel.add((Widget)closeButton);
            panel.setWidget((Widget)vpanel);
        }
        int height = RootPanel.getBodyElement().getClientHeight();
        int width = RootPanel.getBodyElement().getClientWidth();
        panel.setPopupPosition(width / 2 - 150, (height - 100) / 2);
        panel.show();
    }

    private void deleteForm(FormRepresentation form) {
        HashMap<String, FormRepresentation> dataSnapshot = new HashMap<String, FormRepresentation>();
        dataSnapshot.put("form", form);
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
    }

    static /* synthetic */ String access$000() {
        return DELETE_TYPE;
    }

    static /* synthetic */ void access$100(DeleteFormCommand x0, FormRepresentation x1) {
        x0.showDeletePanel(x1);
    }

    static /* synthetic */ void access$200(DeleteFormCommand x0, FormRepresentation x1) {
        x0.deleteForm(x1);
    }

    static /* synthetic */ FormBuilderService access$300(DeleteFormCommand x0) {
        return x0.service;
    }

    static /* synthetic */ I18NConstants access$400(DeleteFormCommand x0) {
        return x0.i18n;
    }

    static /* synthetic */ EventBus access$500(DeleteFormCommand x0) {
        return x0.bus;
    }
}

