/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.ClippedImagePrototype;
import com.gwtent.reflection.client.Reflectable;
import com.yesmail.gwt.rolodex.client.RolodexCard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.OptionsFormItem;
import org.jbpm.formapi.common.panels.ImageRolodexPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.ImageRolodexRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class ImageRolodexFormItem
extends OptionsFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final ImageRolodexPanel panel = new ImageRolodexPanel(FormBuilderResources.INSTANCE.defaultImage(), 400);
    private boolean animated = true;
    private int selectedIndex = 0;
    private List<String> urls = new ArrayList();
    private String cssClassName = null;

    public ImageRolodexFormItem() {
        this(new ArrayList());
    }

    public ImageRolodexFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.panel.setSize("400px", "180px");
        this.setSize("400px", "180px");
        this.add((Widget)this.panel);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("animated", this.animated);
        map.put("selectedIndex", this.selectedIndex + 1);
        map.put("cssClassName", this.cssClassName);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.animated = this.extractBoolean(asPropertiesMap.get("animated"));
        Integer ind = this.extractInt(asPropertiesMap.get("selectedIndex"));
        this.selectedIndex = ind == null || ind <= 0 ? 0 : ind - 1;
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.populate(this.panel);
    }

    private void populate(ImageRolodexPanel panel) {
        panel.setSize(this.getWidth(), this.getHeight());
        if (this.urls != null) {
            for (String url : this.urls) {
                RolodexCard card = this.createCard(url);
                panel.add(card);
            }
        }
        panel.setSelectedCard(panel.get(this.selectedIndex));
        panel.setAnimated(this.animated);
        panel.setStyleName(this.cssClassName);
    }

    private RolodexCard createCard(String url) {
        ClippedImagePrototype expanded = new ClippedImagePrototype(url, 0, 0, this.getOffsetWidth() / 2, this.getOffsetHeight());
        ClippedImagePrototype collapseLeft = new ClippedImagePrototype(url, 0, 0, this.getOffsetWidth() / 4, this.getOffsetHeight() / 2);
        ClippedImagePrototype collapseRight = new ClippedImagePrototype(url, 0, 0, this.getOffsetWidth() / 4, this.getOffsetHeight() / 2);
        int expandedWidth = this.getOffsetWidth() / 2;
        int collapsedWidth = this.getOffsetWidth() / 4;
        int heightOffset = this.getOffsetHeight() / 4;
        RolodexCard card = new RolodexCard((AbstractImagePrototype)expanded, (AbstractImagePrototype)collapseLeft, (AbstractImagePrototype)collapseRight, expandedWidth, collapsedWidth, heightOffset);
        return card;
    }

    public FormItemRepresentation getRepresentation() {
        ImageRolodexRepresentation irrep = new ImageRolodexRepresentation();
        irrep.setAnimated(this.animated);
        irrep.setImageUrls(this.urls);
        irrep.setSelectedIndex(this.selectedIndex);
        return irrep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof ImageRolodexRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "ImageRolodexRepresentation"));
        }
        super.populate(rep);
        ImageRolodexRepresentation irep = (ImageRolodexRepresentation)rep;
        this.selectedIndex = irep.getSelectedIndex();
        this.animated = irep.isAnimated();
        this.urls = irep.getImageUrls();
        this.populate(this.panel);
    }

    public FBFormItem cloneItem() {
        ImageRolodexFormItem clone = (ImageRolodexFormItem)super.cloneItem((FBFormItem)new ImageRolodexFormItem());
        clone.animated = this.animated;
        clone.cssClassName = this.cssClassName;
        clone.selectedIndex = this.selectedIndex;
        clone.urls = new ArrayList(this.urls);
        clone.populate(clone.panel);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        ImageRolodexPanel panel;
        block2: {
            Object input;
            block3: {
                Object[] arr;
                input = this.getInputValue(formData);
                panel = ((ImageRolodexFormItem)this.cloneItem()).panel;
                if (input == null) break block2;
                if (!input.getClass().isArray()) break block3;
                for (Object obj : arr = (Object[])input) {
                    panel.add(this.createCard(obj.toString()));
                }
                break block2;
            }
            if (!(input instanceof Collection)) break block2;
            Collection col = (Collection)input;
            for (Object obj : col) {
                panel.add(this.createCard(obj.toString()));
            }
        }
        return panel;
    }

    public void setSize(String width, String height) {
        super.setSize(width, height);
        if (width != null && width.endsWith("px") && height != null && height.endsWith("px")) {
            List cards = this.panel.getCards();
            this.panel.clear();
            for (RolodexCard card : cards) {
                this.panel.add(this.createCard(card.getExpandedImagePrototype().createImage().getUrl()));
            }
        }
    }

    public void addItem(String index, String url) {
        this.urls.add(url);
        this.panel.add(this.createCard(url));
    }

    public void deleteItem(String index) {
        this.urls.remove(index);
        if (index != null && !"".equals(index)) {
            Integer i = Integer.valueOf(index);
            RolodexCard card = this.panel.get(i - 1);
            this.panel.remove((Widget)card);
        }
    }

    public Map<String, String> getItems() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.panel.size(); ++i) {
            RolodexCard card = this.panel.get(i);
            map.put(String.valueOf(i), card.getExpandedImagePrototype().createImage().getUrl());
        }
        return map;
    }
}

