/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.TextAreaRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class TextAreaFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private TextArea area = new TextArea();
    private String defaultValue;
    private Integer rows = 3;
    private Integer cols = 30;
    private String name;
    private String id;

    public TextAreaFormItem() {
        this(new ArrayList());
    }

    public TextAreaFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.area.setVisibleLines(this.rows.intValue());
        this.area.setCharacterWidth(this.cols.intValue());
        this.add((Widget)this.area);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultValue", this.defaultValue);
        map.put("rows", this.rows);
        map.put("cols", this.cols);
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        Integer rows = this.extractInt(asPropertiesMap.get("rows"));
        Integer cols = this.extractInt(asPropertiesMap.get("cols"));
        this.defaultValue = this.extractString(asPropertiesMap.get("defaultValue"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        if (rows != null && rows > 0) {
            this.rows = rows;
        }
        if (cols != null && cols > 0) {
            this.cols = cols;
        }
        this.populate(this.area);
    }

    private void populate(TextArea area) {
        if (this.rows != null) {
            area.setVisibleLines(this.rows.intValue());
        }
        if (this.cols != null) {
            area.setCharacterWidth(this.cols.intValue());
        }
        if (this.defaultValue != null) {
            area.setValue((Object)this.defaultValue);
        }
        if (this.name != null) {
            area.setName(this.name);
        }
        if (this.getWidth() != null) {
            area.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            area.setHeight(this.getHeight());
        }
    }

    public FormItemRepresentation getRepresentation() {
        TextAreaRepresentation rep = (TextAreaRepresentation)super.getRepresentation((FormItemRepresentation)new TextAreaRepresentation());
        rep.setCols(this.cols.intValue());
        rep.setId(this.id);
        rep.setName(this.name);
        rep.setRows(this.rows.intValue());
        rep.setValue(this.defaultValue);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof TextAreaRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "TextAreaRepresentation"));
        }
        super.populate(rep);
        TextAreaRepresentation trep = (TextAreaRepresentation)rep;
        this.cols = trep.getCols();
        this.id = trep.getId();
        this.name = trep.getName();
        this.rows = trep.getRows();
        this.defaultValue = trep.getValue();
        this.populate(this.area);
    }

    public FBFormItem cloneItem() {
        TextAreaFormItem clone = new TextAreaFormItem(this.getFormEffects());
        clone.cols = this.cols;
        clone.defaultValue = this.defaultValue;
        clone.id = this.id;
        clone.name = this.name;
        clone.rows = this.rows;
        clone.populate(clone.area);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        TextArea ta = new TextArea();
        this.populate(ta);
        Object input = this.getInputValue(data);
        if (input != null) {
            ta.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            ta.setName(this.getOutput().getName());
        }
        super.populateActions(ta.getElement());
        return ta;
    }

    public String getInputValue() {
        return this.area.getValue();
    }
}

