/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepoHelper {
    Map<String, TaskRef> tasksMap = new HashMap();
    List<TaskRef> tasks = new ArrayList();
    String procId = null;
    String procName = null;
    String pkgName = null;

    public void clear() {
        this.tasks.clear();
        this.tasksMap.clear();
        this.procId = null;
        this.procName = null;
        this.pkgName = null;
    }

    public void addTask(TaskRef task) {
        TaskRef oldTask = (TaskRef)this.tasksMap.get(task.getTaskName());
        if (oldTask != null) {
            this.tasks.remove(oldTask);
            for (TaskPropertyRef input : task.getInputs()) {
                oldTask.addInput(input.getName(), input.getSourceExpresion());
            }
            for (TaskPropertyRef output : task.getOutputs()) {
                oldTask.addOutput(output.getName(), output.getSourceExpresion());
            }
            Map metaData = oldTask.getMetaData();
            metaData.putAll(task.getMetaData());
            oldTask.setMetaData(metaData);
            task = oldTask;
        }
        task.setProcessId(this.procId);
        task.setPackageName(this.pkgName);
        this.tasks.add(task);
        this.tasksMap.put(task.getTaskName(), task);
    }

    public List<TaskRef> getTasks() {
        return this.tasks;
    }

    public void addOutput(String processInputName, String id) {
        for (TaskRef task : this.tasks) {
            if (!task.getTaskName().equals(processInputName)) continue;
            TaskPropertyRef prop = new TaskPropertyRef();
            prop.setName(id);
            prop.setSourceExpresion("${" + id + "}");
            if (!task.getOutputs().contains(prop)) {
                task.addOutput(id, "${" + id + "}");
            }
            return;
        }
        TaskRef ref = new TaskRef();
        ref.setTaskId(processInputName);
        ref.setPackageName(this.pkgName);
        ref.setProcessId(this.procId);
        ref.addOutput(id, "${" + id + "}");
        this.tasks.add(ref);
        this.tasksMap.put(ref.getTaskName(), ref);
    }

    public void setDefaultProcessId(String processId) {
        this.procId = processId;
        for (TaskRef task : this.tasks) {
            task.setProcessId(this.procId);
        }
    }

    public void setDefaultProcessName(String processName) {
        this.procName = processName;
        for (TaskRef task : this.tasks) {
            task.setProcessName(this.procName);
        }
    }

    public void setDefaultPackageName(String packageName) {
        this.pkgName = packageName;
        for (TaskRef task : this.tasks) {
            task.setPackageName(this.pkgName);
        }
    }
}

