/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationEncoder;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationResponseEvent;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.messages.I18NConstants;

public class FormExporter {
    private static final String EXPORT_TYPE = FormExporter.class.getName();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();

    public FormExporter() {
        this.bus.addHandler(UndoableEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(GetFormRepresentationResponseEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void exportForm(FormRepresentation form) {
        FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
        try {
            String formAsJson = encoder.encode(form);
            this.setClientExportForm(formAsJson);
        }
        catch (FormEncodingException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.CouldntExportAsJson(), (Throwable)e));
        }
    }

    protected final native void start();

    private final native void setClientExportForm(String var1);

    static /* synthetic */ String access$000() {
        return EXPORT_TYPE;
    }

    static /* synthetic */ EventBus access$100(FormExporter x0) {
        return x0.bus;
    }
}

