/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.messages.I18NConstants;

public class RoleUtils {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final List<String> roles = new ArrayList();
    private static final RoleUtils INSTANCE = new RoleUtils();

    public static RoleUtils getInstance() {
        return INSTANCE;
    }

    private RoleUtils() {
        this.reload();
    }

    public void reload() {
        try {
            this.roles.clear();
            FormBuilderService server = FormBuilderGlobals.getInstance().getService();
            if (server != null) {
                server.getCurrentRoles((FormBuilderService.RolesResponseHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (FormBuilderException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.RolesNotRead(), (Throwable)e));
        }
    }

    public boolean hasDesignPrivileges() {
        return this.roles.contains("admin") || this.roles.contains("webdesigner");
    }

    public boolean hasOnlyUserPrivileges() {
        return this.roles.contains("functionalanalyst") && !this.hasDesignPrivileges();
    }

    static /* synthetic */ List access$000(RoleUtils x0) {
        return x0.roles;
    }
}

