/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.command;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.HashMap;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.bus.LoadServerFormEvent;
import org.jbpm.formbuilder.client.bus.LoadServerFormResponseEvent;
import org.jbpm.formbuilder.client.bus.ui.UpdateFormViewEvent;
import org.jbpm.formbuilder.client.command.BaseCommand;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class LoadFormCommand
implements BaseCommand {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final FormBuilderService service = FormBuilderGlobals.getInstance().getService();
    private MenuItem item = null;

    public LoadFormCommand() {
        this.bus.addHandler(LoadServerFormEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(LoadServerFormResponseEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void populateFormView(FormRepresentation form) {
        this.bus.fireEvent((GwtEvent)new UpdateFormViewEvent(form));
    }

    private void popupFormSelection(List<FormRepresentation> forms) {
        HashMap<String, FormRepresentation> formMap = new HashMap<String, FormRepresentation>();
        ListBox names = new ListBox();
        for (FormRepresentation form : forms) {
            names.addItem(form.getName());
            formMap.put(form.getName(), form);
        }
        PopupPanel panel = new PopupPanel(false, true);
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel selectPanel = new HorizontalPanel();
        selectPanel.add((Widget)new Label(this.i18n.SelectAFormLabel()));
        selectPanel.add((Widget)names);
        vPanel.add((Widget)selectPanel);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        Button loadButton = new Button(this.i18n.LoadButton());
        loadButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button cancelButton = new Button(this.i18n.CancelButton());
        cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)new HTML("&nbsp;"));
        buttonPanel.add((Widget)loadButton);
        buttonPanel.add((Widget)cancelButton);
        vPanel.add((Widget)buttonPanel);
        panel.add((Widget)vPanel);
        panel.setPopupPosition(RootPanel.getBodyElement().getClientWidth() / 2 - 150, RootPanel.getBodyElement().getClientHeight() / 2 - 150);
        panel.show();
    }

    public void execute() {
        this.bus.fireEvent((GwtEvent)new LoadServerFormEvent());
    }

    public void setItem(MenuItem item) {
        this.item = item;
        item.setEnabled(true);
    }

    public void setEmbeded(String profile) {
        if (this.item != null) {
            this.item.getParentMenu().removeItem(this.item);
        }
    }

    static /* synthetic */ FormBuilderService access$000(LoadFormCommand x0) {
        return x0.service;
    }

    static /* synthetic */ I18NConstants access$100(LoadFormCommand x0) {
        return x0.i18n;
    }

    static /* synthetic */ EventBus access$200(LoadFormCommand x0) {
        return x0.bus;
    }

    static /* synthetic */ void access$300(LoadFormCommand x0, List x1) {
        x0.popupFormSelection(x1);
    }

    static /* synthetic */ void access$400(LoadFormCommand x0, FormRepresentation x1) {
        x0.populateFormView(x1);
    }
}

