/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.view;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.effect.I18NFormEffect;
import org.jbpm.formbuilder.client.effect.view.I18NEffectView;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

public class I18NEffectView
extends PopupPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final Grid grid = new Grid(2, 3);
    private final TextBox defaultText;
    private final I18NFormEffect effect;

    public I18NEffectView(I18NFormEffect formEffect) {
        this.effect = formEffect;
        this.defaultText = this.messageTextBox((String)this.effect.getItemI18nMap().get("default"));
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add((Widget)this.grid);
        this.populateGrid();
        HorizontalPanel buttonPanel = new HorizontalPanel();
        Button addLocaleButton = new Button(this.i18n.AddLocaleButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button doneButton = new Button(this.i18n.ConfirmButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button cancelButton = new Button(this.i18n.CancelButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)addLocaleButton);
        buttonPanel.add((Widget)doneButton);
        buttonPanel.add((Widget)cancelButton);
        buttonPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        mainPanel.add((Widget)buttonPanel);
        this.add((Widget)mainPanel);
    }

    private void populateGrid() {
        this.grid.setWidget(0, 0, (Widget)new Label("default:"));
        this.grid.setWidget(0, 1, (Widget)this.defaultText);
        this.grid.setWidget(1, 0, (Widget)new Label(this.i18n.LocalesLabel()));
        this.grid.setWidget(1, 1, (Widget)new Label(this.i18n.MessagesLabel()));
        for (Map.Entry entry : this.effect.getItemI18nMap().entrySet()) {
            if ("default".equals(entry.getKey())) continue;
            this.addLocaleToGrid((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void addLocaleToGrid(String localeName, String localeMessage) {
        this.grid.resizeRows(this.grid.getRowCount() + 1);
        int rowNumber = this.grid.getRowCount() - 1;
        this.grid.setWidget(rowNumber, 0, (Widget)this.messageTextBox(localeName));
        this.grid.setWidget(rowNumber, 1, (Widget)this.messageTextBox(localeMessage));
        this.grid.setWidget(rowNumber, 2, (Widget)this.removeButton());
    }

    private Button removeButton() {
        Image img = new Image(FormBuilderResources.INSTANCE.removeSmallIcon());
        SafeHtmlBuilder builder = new SafeHtmlBuilder().appendHtmlConstant(img.toString());
        Button removeButton = new Button(builder.toSafeHtml());
        4 handler = new /* Unavailable Anonymous Inner Class!! */;
        removeButton.addClickHandler((ClickHandler)handler);
        return removeButton;
    }

    private TextBox messageTextBox(String value) {
        TextBox textBox = new TextBox();
        if (value != null) {
            textBox.setValue((Object)value);
        }
        return textBox;
    }

    static /* synthetic */ void access$000(I18NEffectView x0, String x1, String x2) {
        x0.addLocaleToGrid(x1, x2);
    }

    static /* synthetic */ TextBox access$100(I18NEffectView x0) {
        return x0.defaultText;
    }

    static /* synthetic */ Grid access$200(I18NEffectView x0) {
        return x0.grid;
    }

    static /* synthetic */ I18NFormEffect access$300(I18NEffectView x0) {
        return x0.effect;
    }
}

