/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.common.panels.CalendarPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.CalendarRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class CalendarFormItem
extends FBFormItem {
    private String defaultValue;
    private String iconUrl;
    private String calendarCss;
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final DateTimeFormat format = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_LONG);
    private final DatePicker calendar = new DatePicker();
    private final Image icon = new Image();
    private final PopupPanel panel = new PopupPanel();
    private final TextBox text = new TextBox();

    public CalendarFormItem() {
        this(new ArrayList());
    }

    public CalendarFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.iconUrl = FormBuilderResources.INSTANCE.calendarSquare().getURL();
        this.icon.setUrl(this.iconUrl);
        this.icon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.icon.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.calendar.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.calendar.setSize("183px", "183px");
        CalendarPanel cPanel = new CalendarPanel((Widget)this.text, (Widget)this.icon);
        cPanel.add((Widget)this.text);
        cPanel.add((Widget)this.icon);
        this.text.setSize("175px", "21px");
        cPanel.setSize("200px", "21px");
        this.setSize("200px", "21px");
        this.add((Widget)cPanel);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("iconUrl", this.iconUrl);
        map.put("calendarCss", this.calendarCss);
        map.put("defaultValue", this.defaultValue);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.iconUrl = this.extractString(asPropertiesMap.get("iconUrl"));
        this.calendarCss = this.extractString(asPropertiesMap.get("calendarCss"));
        this.defaultValue = this.extractString(asPropertiesMap.get("defaultValue"));
        this.populate(this.calendar, this.text, this.icon);
    }

    private void populate(DatePicker calendar, TextBox text, Image icon) {
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            calendar.setHeight(this.getHeight());
        }
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            calendar.setWidth(this.getWidth());
        }
        if (this.defaultValue != null) {
            if (!"".equals(this.defaultValue)) {
                calendar.setValue(this.format.parse(this.defaultValue));
            } else {
                calendar.setValue(null);
            }
        }
        if (this.calendarCss != null && !"".equals(this.calendarCss)) {
            calendar.setStyleName(this.calendarCss);
        }
        if (this.iconUrl != null && !"".equals(this.iconUrl)) {
            icon.setUrl(this.iconUrl);
        }
        String cursor = icon.getElement().getStyle().getCursor();
        if (!Style.Cursor.POINTER.getCssName().equals(cursor)) {
            icon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        }
    }

    public FormItemRepresentation getRepresentation() {
        CalendarRepresentation crep = (CalendarRepresentation)super.getRepresentation((FormItemRepresentation)new CalendarRepresentation());
        crep.setIconUrl(this.iconUrl);
        crep.setCalendarCss(this.calendarCss);
        crep.setDefaultValue(this.defaultValue);
        return crep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof CalendarRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "CalendarRepresentation"));
        }
        super.populate(rep);
        CalendarRepresentation crep = (CalendarRepresentation)rep;
        this.calendarCss = crep.getCalendarCss();
        this.iconUrl = crep.getIconUrl();
        this.defaultValue = crep.getDefaultValue();
        this.populate(this.calendar, this.text, this.icon);
    }

    public FBFormItem cloneItem() {
        CalendarFormItem clone = (CalendarFormItem)super.cloneItem((FBFormItem)new CalendarFormItem());
        clone.calendarCss = this.calendarCss;
        clone.defaultValue = this.defaultValue;
        clone.iconUrl = this.iconUrl;
        this.populate(clone.calendar, clone.text, clone.icon);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        DatePicker date = new DatePicker();
        TextBox textBox = new TextBox();
        PopupPanel panel = new PopupPanel();
        DatePicker calendar = new DatePicker();
        if (this.calendarCss != null && !"".equals(this.calendarCss)) {
            calendar.setStyleName(this.calendarCss);
        }
        panel.setSize("183px", "183px");
        panel.setWidget((Widget)calendar);
        Image icon = new Image();
        icon.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.populate(date, textBox, icon);
        CalendarPanel display = new CalendarPanel((Widget)textBox, (Widget)icon);
        Object input = this.getInputValue(data);
        if (input != null) {
            textBox.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            textBox.setName(this.getOutput().getName());
        }
        super.populateActions(textBox.getElement());
        return display;
    }

    static /* synthetic */ PopupPanel access$000(CalendarFormItem x0) {
        return x0.panel;
    }

    static /* synthetic */ DatePicker access$100(CalendarFormItem x0) {
        return x0.calendar;
    }

    static /* synthetic */ DateTimeFormat access$200(CalendarFormItem x0) {
        return x0.format;
    }

    static /* synthetic */ TextBox access$300(CalendarFormItem x0) {
        return x0.text;
    }
}

