/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.common.panels.RangeBox;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.RangeFieldRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class RangeFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final RangeBox rangeBox = new RangeBox();
    private Double defaultValue = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Double max = null;
    private Double min = null;
    private Double step = null;

    public RangeFieldFormItem() {
        this(new ArrayList());
    }

    public RangeFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.rangeBox);
        this.setWidth("150px");
        this.setHeight("25px");
        this.rangeBox.setWidth(this.getWidth());
        this.rangeBox.setHeight(this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultValue", this.defaultValue);
        map.put("name", this.name);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("max", this.max);
        map.put("min", this.min);
        map.put("step", this.step);
        map.put("title", this.title);
        map.put("id", this.id);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultValue = this.extractDouble(asPropertiesMap.get("defaultValue"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.max = this.extractDouble(asPropertiesMap.get("max"));
        this.min = this.extractDouble(asPropertiesMap.get("min"));
        this.step = this.extractDouble(asPropertiesMap.get("step"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.rangeBox);
    }

    private void populate(RangeBox rangeBox) {
        if (this.defaultValue != null) {
            rangeBox.setValue((Object)this.defaultValue);
        }
        if (this.name != null) {
            rangeBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            rangeBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            rangeBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            rangeBox.setTitle(this.title);
        }
        if (this.max != null) {
            rangeBox.setMax(this.max);
        }
        if (this.max != null) {
            rangeBox.setMin(this.min);
        }
        if (this.max != null) {
            rangeBox.setStep(this.step);
        }
    }

    public FormItemRepresentation getRepresentation() {
        RangeFieldRepresentation rep = (RangeFieldRepresentation)super.getRepresentation((FormItemRepresentation)new RangeFieldRepresentation());
        rep.setDefaultValue(this.defaultValue);
        rep.setName(this.name);
        rep.setId(this.id);
        rep.setMax(this.max);
        rep.setMin(this.min);
        rep.setStep(this.step);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof RangeFieldRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "RangeFieldRepresentation"));
        }
        super.populate(rep);
        RangeFieldRepresentation rrep = (RangeFieldRepresentation)rep;
        this.defaultValue = rrep.getDefaultValue();
        this.name = rrep.getName();
        this.id = rrep.getId();
        this.max = rrep.getMax();
        this.min = rrep.getMin();
        this.step = rrep.getStep();
        if (rrep.getWidth() != null && !"".equals(rrep.getWidth())) {
            this.setWidth(rrep.getWidth());
        }
        if (rrep.getHeight() != null && !"".equals(rrep.getHeight())) {
            this.setHeight(rrep.getHeight());
        }
        this.populate(this.rangeBox);
    }

    public FBFormItem cloneItem() {
        RangeFieldFormItem clone = new RangeFieldFormItem(this.getFormEffects());
        clone.defaultValue = this.defaultValue;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.max = this.max;
        clone.min = this.min;
        clone.step = this.step;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.rangeBox);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        RangeBox tb = new RangeBox();
        this.populate(tb);
        Object input = this.getInputValue(formData);
        if (input != null) {
            String inputValue = input.toString();
            tb.setValue((Object)(inputValue.equals("") ? null : Double.valueOf(inputValue)));
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            tb.setName(this.getOutput().getName());
        }
        super.populateActions(tb.getElement());
        return tb;
    }
}

