/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jbpm.formapi.server.form.FormEncodingServerFactory;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.formapi.shared.form.FormRepresentationEncoder;
import org.jbpm.formapi.shared.menu.FormEffectDescription;
import org.jbpm.formapi.shared.menu.MenuItemDescription;
import org.jbpm.formbuilder.client.menu.items.CustomMenuItem;
import org.jbpm.formbuilder.server.RESTBaseService;
import org.jbpm.formbuilder.server.RESTUserService;
import org.jbpm.formbuilder.server.ServiceFactory;
import org.jbpm.formbuilder.server.xml.FormEffectDTO;
import org.jbpm.formbuilder.server.xml.ListMenuItemsDTO;
import org.jbpm.formbuilder.server.xml.ListOptionsDTO;
import org.jbpm.formbuilder.server.xml.ListValidationsDTO;
import org.jbpm.formbuilder.server.xml.PropertiesDTO;
import org.jbpm.formbuilder.server.xml.SaveMenuItemDTO;
import org.jbpm.formbuilder.shared.menu.MenuService;
import org.jbpm.formbuilder.shared.menu.MenuServiceException;

@Path(value="/menu")
public class RESTMenuService
extends RESTBaseService {
    private MenuService menuService;

    public RESTMenuService() {
        FormEncodingFactory.register((FormRepresentationEncoder)FormEncodingServerFactory.getEncoder(), (FormRepresentationDecoder)FormEncodingServerFactory.getDecoder());
    }

    @GET
    @Path(value="/items")
    public Response listMenuItems() {
        this.init();
        try {
            Map items = this.menuService.listMenuItems();
            ListMenuItemsDTO dto = new ListMenuItemsDTO(items);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (MenuServiceException e) {
            return this.error("Problem reading menu items", (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/options")
    public Response listMenuOptions() {
        this.init();
        try {
            List options = this.menuService.listOptions();
            ListOptionsDTO dto = new ListOptionsDTO(options);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (MenuServiceException e) {
            return this.error("Problem reading menu options", (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/validations")
    public Response getValidations() {
        this.init();
        try {
            List validations = this.menuService.listValidations();
            ListValidationsDTO dto = new ListValidationsDTO(validations);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (MenuServiceException e) {
            return this.error("Problem reading validations", (Exception)((Object)e));
        }
    }

    @POST
    @Path(value="/items")
    public Response saveMenuItem(SaveMenuItemDTO dto, @Context HttpServletRequest request) {
        this.init();
        try {
            if (RESTUserService.hasDesignerPrivileges((HttpServletRequest)request)) {
                MenuItemDescription menuItem = this.toMenuItemDescription(dto, true);
                this.menuService.saveMenuItem(dto.getGroupName(), menuItem);
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (MenuServiceException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
    }

    private MenuItemDescription toMenuItemDescription(SaveMenuItemDTO dto, boolean strict) throws MenuServiceException {
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        String json = dto.getClone();
        MenuItemDescription menuItem = new MenuItemDescription();
        try {
            FormItemRepresentation item = decoder.decodeItem(json);
            menuItem.setItemRepresentation(item);
        }
        catch (FormEncodingException e) {
            if (strict) {
                throw new MenuServiceException("Couldn't load formRepresentation from dto", (Throwable)e);
            }
            menuItem.setItemRepresentation(null);
        }
        menuItem.setClassName(CustomMenuItem.class.getName());
        menuItem.setName(dto.getName());
        ArrayList<FormEffectDescription> effects = new ArrayList<FormEffectDescription>();
        if (dto.getEffect() != null) {
            for (FormEffectDTO effectDto : dto.getEffect()) {
                FormEffectDescription effect = new FormEffectDescription();
                effect.setClassName(effectDto.getClassName());
                effects.add(effect);
            }
        }
        menuItem.setEffects(effects);
        ArrayList<String> allowedEvents = new ArrayList<String>();
        if (dto.getAllowedEvent() != null) {
            for (String evtName : dto.getAllowedEvent()) {
                allowedEvents.add(evtName);
            }
        }
        menuItem.setAllowedEvents(allowedEvents);
        return menuItem;
    }

    @DELETE
    @Path(value="/items")
    public Response deleteMenuItem(SaveMenuItemDTO dto, @Context HttpServletRequest request) {
        this.init();
        try {
            if (RESTUserService.hasDesignerPrivileges((HttpServletRequest)request)) {
                MenuItemDescription menuItem = this.toMenuItemDescription(dto, false);
                Map items = this.menuService.listMenuItems();
                List group = (List)items.get(dto.getGroupName());
                if (group == null || group.isEmpty()) {
                    return Response.noContent().build();
                }
                boolean found = false;
                for (MenuItemDescription desc : group) {
                    if (!desc.getName().equals(dto.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return Response.status((Response.Status)Response.Status.CONFLICT).build();
                }
                this.menuService.deleteMenuItem(dto.getGroupName(), menuItem);
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (MenuServiceException e) {
            return this.error("Couldn't delete menu item " + dto.getGroupName() + ":" + dto.getName(), (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/mappings")
    public Response getRepresentationMappings() {
        this.init();
        try {
            Map props = this.menuService.getFormBuilderProperties();
            PropertiesDTO dto = new PropertiesDTO(props);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (MenuServiceException e) {
            return this.error("Problem reading form builder properties", (Exception)((Object)e));
        }
    }

    private void init() {
        if (this.menuService == null) {
            this.menuService = ServiceFactory.getInstance().getMenuService();
        }
    }

    public void setMenuService(MenuService menuService) {
        this.menuService = menuService;
    }
}

