/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.file;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jbpm.formbuilder.server.GuvnorHelper;
import org.jbpm.formbuilder.server.file.FileException;
import org.jbpm.formbuilder.server.file.FileService;
import org.jbpm.formbuilder.server.xml.MetaDataDTO;
import org.jbpm.formbuilder.server.xml.PackageAssetDTO;
import org.jbpm.formbuilder.server.xml.PackageAssetsDTO;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuvnorFileService
implements FileService,
InitializingBean {
    private GuvnorHelper helper;
    private String baseUrl;
    private String user;
    private String password;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void afterPropertiesSet() throws Exception {
        this.helper = new GuvnorHelper(this.baseUrl, this.user, this.password);
    }

    public void setHelper(GuvnorHelper helper) {
        this.helper = helper;
    }

    public GuvnorHelper getHelper() {
        return this.helper;
    }

    public String extractFileExtension(String fileName) {
        int dotInd = fileName.lastIndexOf(46);
        return dotInd > 0 && dotInd < fileName.length() ? fileName.substring(dotInd + 1) : null;
    }

    public String stripFileExtension(String fileName) {
        String assetName;
        int dotInd = fileName.lastIndexOf(46);
        String string = assetName = dotInd > 0 ? fileName.substring(0, dotInd) : fileName;
        if (!assetName.endsWith("-upfile")) {
            assetName = assetName + "-upfile";
        }
        return assetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String storeFile(String packageName, String fileName, byte[] content) throws FileException {
        try {
            String assetName = this.stripFileExtension(fileName);
            String assetExt = this.extractFileExtension(fileName);
            this.deleteOlderVersion(packageName, fileName);
            HttpClient client = this.helper.getHttpClient();
            String createUrl = this.helper.getRestBaseUrl() + URLEncoder.encode(packageName, "UTF-8") + "/assets/";
            PostMethod create = this.helper.createPostMethod(createUrl);
            try {
                this.helper.setAuth(client, (HttpMethod)create);
                create.addRequestHeader("Content-Type", "application/octet-stream");
                create.addRequestHeader("Accept", "application/atom+xml");
                create.addRequestHeader("Slug", assetName + '.' + assetExt);
                create.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
                client.executeMethod((HttpMethod)create);
            }
            finally {
                create.releaseConnection();
            }
            return this.baseUrl + "/org.drools.guvnor.Guvnor/api/packages/" + URLEncoder.encode(packageName, "UTF-8") + "/" + URLEncoder.encode(assetName, "UTF-8") + "." + assetExt;
        }
        catch (Exception e) {
            throw new FileException("Problem storing file", (Throwable)e);
        }
    }

    private void deleteOlderVersion(String packageName, String fileName) throws FileException {
        HttpClient client = this.helper.getHttpClient();
        String assetName = this.stripFileExtension(fileName);
        GetMethod check = null;
        try {
            String deleteUrl = this.helper.getRestBaseUrl() + URLEncoder.encode(packageName, "UTF-8") + "/assets/" + URLEncoder.encode(assetName, "UTF-8");
            check = this.helper.createGetMethod(deleteUrl);
            this.helper.setAuth(client, (HttpMethod)check);
            check.addRequestHeader("Accept", "application/xml");
            client.executeMethod((HttpMethod)check);
            if (check.getStatusCode() == 200) {
                this.deleteFile(packageName, fileName);
            }
        }
        catch (IOException e) {
            throw new FileException("Problem getting old version of asset " + fileName + " in package " + packageName, (Throwable)e);
        }
        finally {
            if (check != null) {
                check.releaseConnection();
            }
        }
    }

    public void deleteFile(String packageName, String fileName) throws FileException {
        HttpClient client = this.helper.getHttpClient();
        String assetName = this.stripFileExtension(fileName);
        DeleteMethod deleteAsset = null;
        try {
            String deleteUrl = this.helper.getRestBaseUrl() + URLEncoder.encode(packageName, "UTF-8") + "/assets/" + URLEncoder.encode(assetName, "UTF-8");
            deleteAsset = this.helper.createDeleteMethod(deleteUrl);
            this.helper.setAuth(client, (HttpMethod)deleteAsset);
            client.executeMethod((HttpMethod)deleteAsset);
        }
        catch (IOException e) {
            throw new FileException("Problem deleting guvnor file", (Throwable)e);
        }
        catch (Exception e) {
            throw new FileException("Unexpected error", (Throwable)e);
        }
        finally {
            if (deleteAsset != null) {
                deleteAsset.releaseConnection();
            }
        }
    }

    public List<String> loadFilesByType(String packageName, String fileType) throws FileException {
        HttpClient client = this.helper.getHttpClient();
        GetMethod load = null;
        try {
            String loadUrl = this.helper.getRestBaseUrl() + URLEncoder.encode(packageName, "UTF-8") + "/assets/";
            load = this.helper.createGetMethod(loadUrl);
            load.addRequestHeader("Accept", "application/xml");
            this.helper.setAuth(client, (HttpMethod)load);
            client.executeMethod((HttpMethod)load);
            PackageAssetsDTO dto = (PackageAssetsDTO)this.helper.jaxbTransformation(PackageAssetsDTO.class, load.getResponseBodyAsStream(), new Class[]{PackageAssetsDTO.class, PackageAssetDTO.class, MetaDataDTO.class});
            ArrayList<PackageAssetDTO> validAssets = new ArrayList<PackageAssetDTO>();
            if (fileType != null && !"".equals(fileType)) {
                for (PackageAssetDTO asset : dto.getAsset()) {
                    if (!asset.getMetadata().getFormat().equals(fileType)) continue;
                    validAssets.add(asset);
                }
            } else {
                validAssets.addAll(dto.getAsset());
            }
            ArrayList<String> retval = new ArrayList<String>();
            for (PackageAssetDTO asset : validAssets) {
                String refLink = asset.getRefLink();
                String fileName = refLink.substring(refLink.lastIndexOf(47) + 1);
                fileName = fileName + "." + asset.getMetadata().getFormat();
                retval.add(this.helper.getApiSearchUrl(packageName) + fileName);
            }
            ArrayList<String> arrayList = retval;
            return arrayList;
        }
        catch (IOException e) {
            throw new FileException("Problem obtaining assets from guvnor", (Throwable)e);
        }
        catch (JAXBException e) {
            throw new FileException("Problem parsing assets from guvnor", (Throwable)e);
        }
        catch (Exception e) {
            throw new FileException("Unexpected error", (Throwable)e);
        }
        finally {
            load.releaseConnection();
        }
    }

    public byte[] loadFile(String packageName, String fileName) throws FileException {
        HttpClient client = this.helper.getHttpClient();
        String assetName = this.stripFileExtension(fileName);
        GetMethod get = null;
        try {
            String getUrl = this.helper.getRestBaseUrl() + URLEncoder.encode(packageName, "UTF-8") + "/assets/" + URLEncoder.encode(assetName, "UTF-8") + "/source";
            get = this.helper.createGetMethod(getUrl);
            this.helper.setAuth(client, (HttpMethod)get);
            client.executeMethod((HttpMethod)get);
            byte[] byArray = get.getResponseBody();
            return byArray;
        }
        catch (IOException e) {
            throw new FileException("Problem reading file " + fileName, (Throwable)e);
        }
        catch (Exception e) {
            throw new FileException("Unexpected error reading file " + fileName, (Throwable)e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }
}

