/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.form;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.formapi.shared.form.FormRepresentationEncoder;
import org.jbpm.formbuilder.server.GuvnorHelper;
import org.jbpm.formbuilder.server.xml.AssetDTO;
import org.jbpm.formbuilder.server.xml.MetaDataDTO;
import org.jbpm.formbuilder.server.xml.PackageDTO;
import org.jbpm.formbuilder.server.xml.PackageListDTO;
import org.jbpm.formbuilder.shared.form.AbstractBaseFormDefinitionService;
import org.jbpm.formbuilder.shared.form.FormDefinitionService;
import org.jbpm.formbuilder.shared.form.FormServiceException;
import org.jbpm.formbuilder.shared.task.TaskRef;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuvnorFormDefinitionService
extends AbstractBaseFormDefinitionService
implements FormDefinitionService,
InitializingBean {
    private String baseUrl;
    private String user;
    private String password;
    private GuvnorHelper helper;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void afterPropertiesSet() throws Exception {
        this.helper = new GuvnorHelper(this.baseUrl, this.user, this.password);
    }

    public void setHelper(GuvnorHelper helper) {
        this.helper = helper;
    }

    public GuvnorHelper getHelper() {
        return this.helper;
    }

    public String saveForm(String pkgName, FormRepresentation form) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        PutMethod method = null;
        try {
            String url = this.helper.getApiSearchUrl(pkgName);
            boolean isUpdate = this.getForm(pkgName, form.getName()) != null;
            String finalUrl = url + URLEncoder.encode(form.getName(), "UTF-8") + ".formdef";
            method = isUpdate ? this.helper.createPutMethod(finalUrl) : this.helper.createPostMethod(finalUrl);
            FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
            method.setRequestEntity((RequestEntity)new StringRequestEntity(encoder.encode(form), null, null));
            method.setRequestHeader("Checkin-Comment", form.getDocumentation());
            this.helper.setAuth(client, (HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            if (!"OK".equalsIgnoreCase(method.getResponseBodyAsString())) {
                throw new FormServiceException("Remote guvnor error: " + method.getResponseBodyAsString());
            }
            String string = form.getName();
            return string;
        }
        catch (IOException e) {
            throw new FormServiceException((Throwable)e);
        }
        catch (FormEncodingException e) {
            throw new FormServiceException((Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof FormServiceException) {
                throw (FormServiceException)((Object)e);
            }
            throw new FormServiceException("Unexpected error", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public String saveFormItem(String pkgName, String formItemName, FormItemRepresentation formItem) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        StringBuilder builder = new StringBuilder();
        boolean isUpdate = this.updateItemName(formItemName, builder);
        PutMethod method = null;
        try {
            String url = this.helper.getApiSearchUrl(pkgName);
            String finalUrl = url + URLEncoder.encode(builder.toString(), "UTF-8") + ".json";
            method = isUpdate ? this.helper.createPutMethod(finalUrl) : this.helper.createPostMethod(finalUrl);
            FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
            method.setRequestEntity((RequestEntity)new StringRequestEntity(encoder.encode(formItem), null, null));
            method.setRequestHeader("Checkin-Comment", "Committing " + formItemName);
            this.helper.setAuth(client, (HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            String string = formItemName;
            return string;
        }
        catch (IOException e) {
            throw new FormServiceException((Throwable)e);
        }
        catch (FormEncodingException e) {
            throw new FormServiceException((Throwable)e);
        }
        catch (Exception e) {
            throw new FormServiceException("Unexpected error", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public FormRepresentation getForm(String pkgName, String formId) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        if (formId != null && !"".equals(formId)) {
            GetMethod method = null;
            FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
            try {
                String getUrl = this.helper.getApiSearchUrl(pkgName) + URLEncoder.encode(formId, "UTF-8") + ".formdef";
                method = this.helper.createGetMethod(getUrl);
                this.helper.setAuth(client, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
                String json = method.getResponseBodyAsString();
                FormRepresentation formRepresentation = decoder.decode(json);
                return formRepresentation;
            }
            catch (IOException e) {
                throw new FormServiceException((Throwable)e);
            }
            catch (FormEncodingException e) {
                throw new FormServiceException((Throwable)e);
            }
            catch (Exception e) {
                throw new FormServiceException("Unexpected error", (Throwable)e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormRepresentation getFormByUUID(String packageName, String uuid) throws FormServiceException {
        block19: {
            HttpClient client = this.helper.getHttpClient();
            if (packageName != null && !"".equals(packageName)) {
                GetMethod call = this.helper.createGetMethod(this.helper.getRestBaseUrl());
                try {
                    this.helper.setAuth(client, (HttpMethod)call);
                    call.addRequestHeader("Accept", "application/xml");
                    client.executeMethod((HttpMethod)call);
                    PackageListDTO dto = (PackageListDTO)this.helper.jaxbTransformation(PackageListDTO.class, call.getResponseBodyAsStream(), new Class[]{PackageListDTO.class, PackageDTO.class});
                    String formDefUrl = null;
                    String format = null;
                    PackageDTO pkg = dto.getSelectedPackage(packageName);
                    for (String url : pkg.getAssets()) {
                        GetMethod subCall = this.helper.createGetMethod(url);
                        try {
                            this.helper.setAuth(client, (HttpMethod)subCall);
                            subCall.addRequestHeader("Accept", "application/xml");
                            client.executeMethod((HttpMethod)subCall);
                            AssetDTO subDto = (AssetDTO)this.helper.jaxbTransformation(AssetDTO.class, subCall.getResponseBodyAsStream(), new Class[]{AssetDTO.class, MetaDataDTO.class});
                            if (!subDto.getMetadata().getUuid().equals(uuid)) continue;
                            formDefUrl = subDto.getSourceLink();
                            format = subDto.getMetadata().getFormat();
                            break;
                        }
                        finally {
                            subCall.releaseConnection();
                        }
                    }
                    if (format == null || !"formdef".equalsIgnoreCase(format)) break block19;
                    GetMethod processCall = this.helper.createGetMethod(formDefUrl);
                    try {
                        this.helper.setAuth(client, (HttpMethod)processCall);
                        client.executeMethod((HttpMethod)processCall);
                        String formJson = processCall.getResponseBodyAsString();
                        if (formJson != null && !"".equals(formJson)) {
                            FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
                            FormRepresentation formRepresentation = decoder.decode(formJson);
                            return formRepresentation;
                        }
                    }
                    finally {
                        processCall.releaseConnection();
                    }
                }
                catch (JAXBException e) {
                    throw new FormServiceException("Couldn't read form " + packageName + " : " + uuid, (Throwable)e);
                }
                catch (IOException e) {
                    throw new FormServiceException("Couldn't read form " + packageName + " : " + uuid, (Throwable)e);
                }
                catch (FormEncodingException e) {
                    throw new FormServiceException("Couldn't parse form " + packageName + " : " + uuid, (Throwable)e);
                }
                catch (Exception e) {
                    if (e instanceof FormServiceException) {
                        throw (FormServiceException)((Object)e);
                    }
                    throw new FormServiceException("Unexpected error", (Throwable)e);
                }
                finally {
                    call.releaseConnection();
                }
            }
        }
        return null;
    }

    public FormItemRepresentation getFormItem(String pkgName, String formItemId) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        if (formItemId != null && !"".equals(formItemId)) {
            GetMethod method = null;
            FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
            try {
                String getUrl = this.helper.getApiSearchUrl(pkgName) + URLEncoder.encode(formItemId, "UTF-8") + ".json";
                method = this.helper.createGetMethod(getUrl);
                this.helper.setAuth(client, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
                String json = method.getResponseBodyAsString();
                FormItemRepresentation formItemRepresentation = decoder.decodeItem(json);
                return formItemRepresentation;
            }
            catch (IOException e) {
                throw new FormServiceException((Throwable)e);
            }
            catch (FormEncodingException e) {
                throw new FormServiceException((Throwable)e);
            }
            finally {
                method.releaseConnection();
            }
        }
        return null;
    }

    public Map<String, FormItemRepresentation> getFormItems(String pkgName) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        GetMethod method = null;
        try {
            method = this.helper.createGetMethod(this.helper.getApiSearchUrl(pkgName));
            this.helper.setAuth(client, (HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            Properties props = new Properties();
            props.load(method.getResponseBodyAsStream());
            HashMap<String, FormItemRepresentation> items = new HashMap<String, FormItemRepresentation>();
            for (Object key : props.keySet()) {
                String assetId = key.toString();
                if (!this.isItemName(assetId)) continue;
                FormItemRepresentation item = this.getFormItem(pkgName, assetId.replace(".json", ""));
                items.put(assetId, item);
            }
            HashMap<String, FormItemRepresentation> hashMap = items;
            return hashMap;
        }
        catch (IOException e) {
            throw new FormServiceException((Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof FormServiceException) {
                throw (FormServiceException)((Object)e);
            }
            throw new FormServiceException("Unexpected error", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public List<FormRepresentation> getForms(String pkgName) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        GetMethod method = null;
        try {
            method = this.helper.createGetMethod(this.helper.getApiSearchUrl(pkgName));
            this.helper.setAuth(client, (HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            Properties props = new Properties();
            props.load(method.getResponseBodyAsStream());
            ArrayList<FormRepresentation> forms = new ArrayList<FormRepresentation>();
            for (Object key : props.keySet()) {
                String assetId = key.toString();
                if (!this.isFormName(assetId)) continue;
                FormRepresentation form = this.getForm(pkgName, assetId.replace(".formdef", ""));
                forms.add(form);
            }
            ArrayList<FormRepresentation> arrayList = forms;
            return arrayList;
        }
        catch (IOException e) {
            throw new FormServiceException((Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof FormServiceException) {
                throw (FormServiceException)((Object)e);
            }
            throw new FormServiceException("Unexpected error", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public void deleteForm(String pkgName, String formId) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        if (formId != null && !"".equals(formId)) {
            DeleteMethod method = null;
            try {
                String deleteUrl = this.helper.getApiSearchUrl(pkgName) + URLEncoder.encode(formId, "UTF-8") + ".formdef";
                method = this.helper.createDeleteMethod(deleteUrl);
                this.helper.setAuth(client, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
            }
            catch (IOException e) {
                throw new FormServiceException((Throwable)e);
            }
            catch (Exception e) {
                throw new FormServiceException("Unexpected error", (Throwable)e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }

    public void deleteFormItem(String pkgName, String formItemId) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        if (formItemId != null && !"".equals(formItemId)) {
            DeleteMethod method = null;
            try {
                String deleteUrl = this.helper.getApiSearchUrl(pkgName) + URLEncoder.encode(formItemId, "UTF-8") + ".json";
                method = this.helper.createDeleteMethod(deleteUrl);
                this.helper.setAuth(client, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
            }
            catch (IOException e) {
                throw new FormServiceException((Throwable)e);
            }
            catch (Exception e) {
                throw new FormServiceException("Unexpected error", (Throwable)e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }

    public FormRepresentation getAssociatedForm(String pkgName, TaskRef task) throws FormServiceException {
        List forms = this.getForms(pkgName);
        FormRepresentation retval = null;
        for (FormRepresentation form : forms) {
            if (form.getTaskId() == null || !form.getTaskId().equals(task.getTaskId())) continue;
            retval = form;
            break;
        }
        return retval;
    }

    public void saveTemplate(String packageName, String templateName, String content) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        PutMethod method = null;
        String emaNetalpmet = StringUtils.reverse((String)templateName);
        emaNetalpmet = emaNetalpmet.replaceFirst("ltf.", "txt.");
        templateName = StringUtils.reverse((String)emaNetalpmet);
        try {
            this.ensureTamplateAsset(packageName, templateName);
            String templateBaseName = StringUtils.reverse((String)StringUtils.reverse((String)templateName).replaceFirst("txt.", ""));
            String sourceUrl = this.helper.getRestBaseUrl() + URLEncoder.encode(packageName, "UTF-8") + "/assets/" + URLEncoder.encode(templateBaseName, "UTF-8") + "/source";
            method = this.helper.createPutMethod(sourceUrl);
            method.setRequestEntity((RequestEntity)new StringRequestEntity(content, null, null));
            method.setRequestHeader("Content-Type", "application/xml");
            this.helper.setAuth(client, (HttpMethod)method);
            client.executeMethod((HttpMethod)method);
        }
        catch (IOException e) {
            String message = method instanceof PutMethod ? "Problem updating template " + packageName + "/" + templateName : "Problem creating template " + packageName + "/" + templateName;
            throw new FormServiceException(message, (Throwable)e);
        }
        catch (FormServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormServiceException("Unexpected error", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void ensureTamplateAsset(String packageName, String templateName) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        if (!this.templateExists(packageName, templateName)) {
            PostMethod method = null;
            try {
                String url = this.helper.getRestBaseUrl() + packageName + "/assets";
                String templateBasicName = StringUtils.reverse((String)StringUtils.reverse((String)templateName).replaceFirst("txt.", ""));
                String templateUrlName = URLEncoder.encode(templateBasicName, "UTF-8");
                method = this.helper.createPostMethod(url);
                this.helper.setAuth(client, (HttpMethod)method);
                method.setRequestHeader("Accept", "application/atom+xml");
                String entry = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entry xmlns=\"http://www.w3.org/2005/Atom\"><author><name>" + this.helper.getUser() + "</name></author>" + "<id>" + url + "/" + templateUrlName + "</id>" + "<title type=\"text\">" + templateBasicName + "</title>" + "<summary type=\"text\">automatic generation</summary>" + "<metadata>" + "<format><value>ftl</value></format>" + "<state><value>Draft</value></state>" + "<archived><value>false</value></archived>" + "</metadata>" + "<content src=\"" + url + "/" + templateUrlName + "/binary\"/>" + "</entry>";
                method.setRequestEntity((RequestEntity)new StringRequestEntity(entry, "application/atom+xml", "UTF-8"));
                client.executeMethod((HttpMethod)method);
            }
            catch (IOException e) {
                throw new FormServiceException("Couldn't create asset for template " + templateName, (Throwable)e);
            }
            catch (Exception e) {
                throw new FormServiceException("Unexpected error", (Throwable)e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean templateExists(String pkgName, String templateName) throws FormServiceException {
        HttpClient client = this.helper.getHttpClient();
        try {
            GetMethod method = this.helper.createGetMethod(this.helper.getApiSearchUrl(pkgName) + URLEncoder.encode(templateName, "UTF-8"));
            try {
                this.helper.setAuth(client, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
                if (method.getStatusCode() == 404) {
                    boolean bl = false;
                    return bl;
                }
                if (method.getStatusCode() == 500 && method.getResponseBodyAsString().contains("PathNotFound")) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                throw new FormServiceException("Problem reading existing template", (Throwable)e);
            }
            catch (Exception e) {
                throw new FormServiceException("Unexpected error", (Throwable)e);
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FormServiceException("Problem encoding template name " + templateName, (Throwable)e);
        }
    }
}

