/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.PopupPanel;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FBScript;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.bus.UndoableHandler;
import org.jbpm.formbuilder.client.effect.view.EventHandlingEffectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class EventHandlingFormEffect
extends FBFormEffect {
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();

    public EventHandlingFormEffect() {
        super("Event handling", true);
    }

    protected void createStyles() {
    }

    public PopupPanel createPanel() {
        return new EventHandlingEffectView(this);
    }

    public boolean isValidForItem(FBFormItem item) {
        return super.isValidForItem(item) && item.getEventActions() != null && !item.getEventActions().isEmpty();
    }

    public Map<String, FBScript> getItemActions() {
        return this.getItem().getEventActions();
    }

    public List<String> getPossibleEvents() {
        Map eventActions = this.getItem().getEventActions();
        if (eventActions != null) {
            return new ArrayList<String>(eventActions.keySet());
        }
        return new ArrayList<String>();
    }

    public void storeEventAction(String eventName, FBScript script) {
        HashMap dataSnapshot = new HashMap();
        dataSnapshot.put("oldScript", this.getItem().getEventActions().get(eventName));
        dataSnapshot.put("newScript", script);
        dataSnapshot.put("eventName", eventName);
        dataSnapshot.put("eventActions", this.getItem().getEventActions());
        dataSnapshot.put("item", this.getItem());
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void confirmEventAction(String eventName, FBScript script) {
        HashMap dataSnapshot = new HashMap();
        dataSnapshot.put("oldScript", this.getItem().getEventActions().get(eventName));
        dataSnapshot.put("newScript", script);
        dataSnapshot.put("eventActions", this.getItemActions());
        dataSnapshot.put("eventName", eventName);
        dataSnapshot.put("item", this.getItem());
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
    }
}

