/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertyLoader.class);
    private static Properties jbpmConsoleProperties = new Properties();

    public static Properties getJbpmConsoleProperties() {
        if (!jbpmConsoleProperties.isEmpty()) {
            return jbpmConsoleProperties;
        }
        InputStream consolePropertiesStream = null;
        try {
            consolePropertiesStream = PropertyLoader.getStreamForConfigFile("/jbpm.console.properties", "/default.jbpm.console.properties");
            jbpmConsoleProperties.load(consolePropertiesStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load jbpm.console.properties", e);
        }
        finally {
            if (consolePropertiesStream != null) {
                try {
                    consolePropertiesStream.close();
                }
                catch (IOException e) {
                    logger.error("Error closing console properties stream, e");
                }
            }
        }
        return jbpmConsoleProperties;
    }

    public static InputStream getStreamForConfigFile(String file, String defaultFile) throws IOException {
        InputStream consolePropertiesStream = null;
        String consolePropertiesPath = System.getProperty("jbpm.conf.dir");
        if (consolePropertiesPath == null) {
            consolePropertiesPath = System.getProperty("jboss.server.config.dir");
        }
        if (consolePropertiesPath == null) {
            consolePropertiesPath = defaultFile;
            consolePropertiesStream = PropertyLoader.class.getResourceAsStream(consolePropertiesPath);
        } else {
            File configFile = new File(consolePropertiesPath = consolePropertiesPath + file);
            if (configFile.exists()) {
                consolePropertiesStream = new FileInputStream(configFile);
            } else {
                consolePropertiesPath = defaultFile;
                consolePropertiesStream = PropertyLoader.class.getResourceAsStream(consolePropertiesPath);
            }
        }
        return consolePropertiesStream;
    }
}

