/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.internal.command.Context;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;

@XmlRootElement(name="get-all-group-audit-tasks-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetAllGroupAuditTasksByUserCommand
extends UserGroupCallbackTaskCommand<List<AuditTask>> {
    private QueryFilter filter;

    public GetAllGroupAuditTasksByUserCommand() {
        this.filter = new QueryFilter(0, 0);
    }

    public GetAllGroupAuditTasksByUserCommand(String userId, QueryFilter filter) {
        this.userId = userId;
        this.filter = filter;
    }

    public List<AuditTask> execute(Context context) {
        TaskPersistenceContext persistenceContext = ((TaskContext)context).getPersistenceContext();
        boolean userExists = this.doCallbackUserOperation(this.userId, (TaskContext)context);
        List groupIds = this.doUserGroupCallbackOperation(this.userId, null, (TaskContext)context);
        List groupTasks = (List)persistenceContext.queryWithParametersInTransaction("getAllGroupAuditTasksByUser", (Map)persistenceContext.addParametersToMap(new Object[]{"firstResult", this.filter.getOffset(), "maxResults", this.filter.getCount()}), ClassUtil.castClass(List.class));
        ArrayList<AuditTask> filteredTasks = new ArrayList<AuditTask>();
        for (AuditTask at : groupTasks) {
            if (at.getPotentialOwners().contains(this.userId)) {
                filteredTasks.add(at);
                continue;
            }
            for (String g : groupIds) {
                if (!at.getPotentialOwners().contains(g)) continue;
                filteredTasks.add(at);
            }
        }
        return filteredTasks;
    }
}

