/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.jms;

import java.util.Date;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.jms.AsyncTaskLifeCycleEventProducer;
import org.jbpm.services.task.events.TaskEventImpl;
import org.jbpm.services.task.utils.TaskFluent;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AsyncTaskLifeCycleEventProducerTest {
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private TextMessage message;
    private AsyncTaskLifeCycleEventProducer logProducer;
    private TaskEvent event;

    @Before
    public void configure() throws JMSException {
        this.connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        this.queue = (Queue)Mockito.mock(Queue.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.session = (Session)Mockito.mock(Session.class);
        this.producer = (MessageProducer)Mockito.mock(MessageProducer.class);
        this.message = (TextMessage)Mockito.mock(TextMessage.class);
        Mockito.when((Object)this.connectionFactory.createConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.createSession(true, 1)).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.createProducer((Destination)Matchers.any())).thenReturn((Object)this.producer);
        Mockito.when((Object)this.session.createTextMessage((String)Matchers.any())).thenReturn((Object)this.message);
        this.logProducer = new AsyncTaskLifeCycleEventProducer(){

            protected AuditTaskImpl getAuditTask(TaskPersistenceContext persistenceContext, Task ti) {
                Task task = new TaskFluent().setName("Updated name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").setProcessId("").setProcessInstanceId(1L).setCreatedOn(new Date()).getTask();
                return this.createAuditTask(task, new Date());
            }
        };
        this.logProducer.setConnectionFactory(this.connectionFactory);
        this.logProducer.setQueue(this.queue);
        this.logProducer.setTransacted(true);
        TaskContext context = (TaskContext)Mockito.mock(TaskContext.class);
        Mockito.when((Object)context.getUserId()).thenReturn((Object)"john");
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").setProcessId("").setProcessInstanceId(1L).setCreatedOn(new Date()).getTask();
        this.event = new TaskEventImpl(task, context);
    }

    @After
    public void assertClose() throws JMSException {
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).close();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testAfterTaskStarted() throws JMSException {
        this.logProducer.afterTaskStartedEvent(this.event);
        this.assertMessage("<type>STARTED</type>", 5);
    }

    @Test
    public void testAfterTaskActivated() throws JMSException {
        this.logProducer.afterTaskActivatedEvent(this.event);
        this.assertMessage("<type>ACTIVATED</type>", 8);
    }

    @Test
    public void testAfterTaskClaimed() throws JMSException {
        this.logProducer.afterTaskClaimedEvent(this.event);
        this.assertMessage("<type>CLAIMED</type>", 8);
    }

    @Test
    public void testAfterTaskSkipped() throws JMSException {
        this.logProducer.afterTaskSkippedEvent(this.event);
        this.assertMessage("<type>SKIPPED</type>", 2);
    }

    @Test
    public void testAfterTaskStopped() throws JMSException {
        this.logProducer.afterTaskStoppedEvent(this.event);
        this.assertMessage("<type>STOPPED</type>", 4);
    }

    @Test
    public void testAfterTaskCompleted() throws JMSException {
        this.logProducer.afterTaskCompletedEvent(this.event);
        this.assertMessage("<type>COMPLETED</type>", 2);
    }

    @Test
    public void testAfterTaskFailed() throws JMSException {
        this.logProducer.afterTaskFailedEvent(this.event);
        this.assertMessage("<type>FAILED</type>", 2);
    }

    @Test
    public void testAfterTaskAdded() throws JMSException {
        this.logProducer.afterTaskAddedEvent(this.event);
        this.assertMessage("<type>ADDED</type>", 9);
    }

    @Test
    public void testAfterTaskExited() throws JMSException {
        this.logProducer.afterTaskExitedEvent(this.event);
        this.assertMessage("<type>EXITED</type>", 2);
    }

    @Test
    public void testAfterTaskReleased() throws JMSException {
        this.logProducer.afterTaskReleasedEvent(this.event);
        this.assertMessage(null, 8);
    }

    @Test
    public void testAfterTaskResumed() throws JMSException {
        this.logProducer.afterTaskResumedEvent(this.event);
        this.assertMessage("<type>RESUMED</type>", 6);
    }

    @Test
    public void testAfterTaskSuspended() throws JMSException {
        this.logProducer.afterTaskSuspendedEvent(this.event);
        this.assertMessage("<type>SUSPENDED</type>", 6);
    }

    @Test
    public void testAfterTaskForwarded() throws JMSException {
        this.logProducer.afterTaskForwardedEvent(this.event);
        this.assertMessage("<type>FORWARDED</type>", 4);
    }

    @Test
    public void testAfterTaskDelegated() throws JMSException {
        this.logProducer.afterTaskDelegatedEvent(this.event);
        this.assertMessage("<type>DELEGATED</type>", 4);
    }

    @Test
    public void testAfterTaskNominated() throws JMSException {
        this.logProducer.afterTaskNominatedEvent(this.event);
        this.assertMessage("<type>NOMINATED</type>", 4);
    }

    @Test
    public void testBeforeTaskReleasedEvent() throws JMSException {
        this.logProducer.beforeTaskReleasedEvent(this.event);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        ((Session)Mockito.verify((Object)this.session)).createTextMessage((String)argument.capture());
        String messageContent = (String)argument.getValue();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)messageContent).isNotNull()).doesNotContain((CharSequence)"<auditTask>").contains(new CharSequence[]{"<org.jbpm.services.task.audit.impl.model.TaskEventImpl>"}).contains(new CharSequence[]{"<type>RELEASED</type>"});
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Task"));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)7));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }

    @Test
    public void testAfterTaskUpdated() throws JMSException {
        this.logProducer.afterTaskUpdatedEvent(this.event);
        this.assertMessage("<type>UPDATED</type>", 4);
    }

    @Test
    public void testAfterTaskReassigned() throws JMSException {
        this.logProducer.afterTaskReassignedEvent(this.event);
        this.assertMessage("<type>DELEGATED</type>", 4);
    }

    @Test
    public void testAfterTaskOutputVariableChanged() throws JMSException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("test", "value");
        this.logProducer.afterTaskOutputVariableChangedEvent(this.event, vars);
        this.assertMessage("<type>UPDATED</type>", 2);
    }

    @Test
    public void testAfterTaskInputVariableChanged() throws JMSException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("test", "value");
        this.logProducer.afterTaskInputVariableChangedEvent(this.event, vars);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        ((Session)Mockito.verify((Object)this.session)).createTextMessage((String)argument.capture());
        String messageContent = (String)argument.getValue();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)messageContent).isNotNull()).doesNotContain((CharSequence)"<auditTask>").doesNotContain((CharSequence)"<org.jbpm.services.task.audit.impl.model.TaskEventImpl>").contains(new CharSequence[]{"<taskInputs>"});
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Task"));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)2));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }

    private void assertMessage(String eventStatus, int messagePriority) throws JMSException {
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        ((Session)Mockito.verify((Object)this.session)).createTextMessage((String)argument.capture());
        String messageContent = (String)argument.getValue();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)messageContent).isNotNull()).contains(new CharSequence[]{"<auditTask>"}).contains(new CharSequence[]{"<name>This is my task name</name>"});
        if (eventStatus != null) {
            Assertions.assertThat((String)messageContent).contains(new CharSequence[]{"<org.jbpm.services.task.audit.impl.model.TaskEventImpl>"}).contains(new CharSequence[]{eventStatus});
        } else {
            Assertions.assertThat((String)messageContent).doesNotContain((CharSequence)"<org.jbpm.services.task.audit.impl.model.TaskEventImpl>");
        }
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Task"));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)messagePriority));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }
}

