/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.audit.TaskAuditServiceFactory;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.jbpm.services.task.impl.TaskDeadlinesServiceImpl;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.test.listener.task.CountDownTaskEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class LocalTaskAuditWithDeadlineTest
extends HumanTaskServicesBaseTest {
    private PoolingDataSourceWrapper pds;
    private EntityManagerFactory emf;
    protected TaskAuditService taskAuditService;

    @Before
    public void setup() {
        TaskDeadlinesServiceImpl.reset();
        this.pds = LocalTaskAuditWithDeadlineTest.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        this.taskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).listener((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true)).listener((TaskLifeCycleEventListener)new BAMTaskEventListener(true)).getTaskService();
        this.taskAuditService = TaskAuditServiceFactory.newTaskAuditServiceConfigurator().setTaskService((TaskService)this.taskService).getTaskAuditService();
    }

    @After
    public void clean() {
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.pds != null) {
            this.pds.close();
        }
    }

    @Test(timeout=10000L)
    public void testDelayedReassignmentOnDeadline() throws Exception {
        CountDownTaskEventListener countDownListener = new CountDownTaskEventListener(1, true, false);
        this.addCountDownListner(countDownListener);
        HashMap<String, Date> vars = new HashMap<String, Date>();
        vars.put("now", new Date());
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/services/task/service/DeadlineWithReassignment.mvel"));
        InternalTask task = (InternalTask)TaskFactory.evalTask((Reader)reader, vars);
        HashMap<String, String> inputVars = new HashMap<String, String>();
        inputVars.put("NotCompletedReassign", "[users:Tony Stark,Bobba Fet,Jabba Hutt|groups:]@[500ms]");
        this.taskService.addTask((Task)task, inputVars);
        long taskId = task.getId();
        this.taskService.claim(taskId, "Tony Stark");
        task = this.taskService.getTaskById(taskId);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Tony Stark"));
        Assert.assertTrue((boolean)ids.contains("Luke Cage"));
        List tasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        AuditTask auditTask = (AuditTask)tasks.get(0);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)auditTask.getStatus());
        Assert.assertEquals((Object)"Tony Stark", (Object)auditTask.getActualOwner());
        countDownListener.waitTillCompleted();
        task = this.taskService.getTaskById(taskId);
        Assert.assertNull((Object)task.getTaskData().getActualOwner());
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        Assert.assertTrue((boolean)ids.contains("Bobba Fet"));
        Assert.assertTrue((boolean)ids.contains("Jabba Hutt"));
        tasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        auditTask = (AuditTask)tasks.get(0);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)auditTask.getStatus());
        Assert.assertEquals((Object)"", (Object)auditTask.getActualOwner());
    }
}

