/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.assertj.core.api.Assertions;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.audit.commands.DeleteAuditEventsCommand;
import org.jbpm.services.task.audit.commands.DeleteBAMTaskSummariesCommand;
import org.jbpm.services.task.audit.commands.GetAuditEventsCommand;
import org.jbpm.services.task.audit.commands.GetBAMTaskSummariesCommand;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.jbpm.services.task.audit.service.objects.Person;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.utils.TaskFluent;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;
import org.kie.internal.task.query.TaskVariableQueryBuilder;

public abstract class TaskAuditBaseTest
extends HumanTaskServicesBaseTest {
    Timestamp today = this.getToday();
    Timestamp tomorrow = this.getTomorrow();
    @Inject
    protected TaskAuditService taskAuditService;

    @Test
    public void testComplete() {
        long initTimeMs = new Date().getTime();
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.complete(taskId, "Darth Vader", null);
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
        List allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand(taskId, new QueryFilter(0, 0)));
        Assert.assertEquals((long)6L, (long)allTaskEvents.size());
        int numFirstTaskEvents = allTaskEvents.size();
        task = new TaskFluent().setName("This is my task name 2").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long secondTaskId = task.getId();
        this.taskService.claim(secondTaskId, "Darth Vader");
        this.taskService.start(secondTaskId, "Darth Vader");
        this.taskService.complete(secondTaskId, "Darth Vader", null);
        allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand());
        int numTaskEvents = allTaskEvents.size();
        Assert.assertTrue((String)("Expected more than " + numFirstTaskEvents + " events: " + numTaskEvents), (numTaskEvents > numFirstTaskEvents ? 1 : 0) != 0);
        this.taskService.execute((Command)new DeleteAuditEventsCommand(taskId));
        allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand());
        Assert.assertEquals((long)(numTaskEvents - numFirstTaskEvents), (long)allTaskEvents.size());
        this.taskService.execute((Command)new DeleteAuditEventsCommand());
        allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand());
        Assert.assertEquals((long)0L, (long)allTaskEvents.size());
        List bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand());
        Assert.assertEquals((String)"BAM Task Summary list size: ", (long)2L, (long)bamTaskList.size());
        this.taskService.execute((Command)new DeleteBAMTaskSummariesCommand(taskId));
        bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand());
        Assert.assertEquals((String)("BAM Task Summary list size after delete (task id: " + taskId + ") : "), (long)1L, (long)bamTaskList.size());
        bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand(secondTaskId));
        Assert.assertEquals((String)("BAM Task Summary list size after delete (task id: " + taskId + ") : "), (long)1L, (long)bamTaskList.size());
        this.taskService.execute((Command)new DeleteBAMTaskSummariesCommand());
        bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand());
        Assert.assertEquals((String)("BAM Task Summary list size after delete (task id: " + taskId + ") : "), (long)0L, (long)bamTaskList.size());
        List allHistoryAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 0));
        Assert.assertEquals((long)2L, (long)allHistoryAuditTasks.size());
        long currentTimeMs = new Date().getTime();
        for (AuditTask at : allHistoryAuditTasks) {
            Date modDate = ((AuditTaskImpl)at).getLastModificationDate();
            Assert.assertNotNull((Object)modDate);
            long modDateMs = modDate.getTime();
            Assert.assertTrue((String)("Task " + at.getTaskId() + " modification date is not too much in the past"), (modDateMs >= initTimeMs ? 1 : 0) != 0);
            Assert.assertTrue((String)("Task " + at.getTaskId() + " modification date is not in the future"), (modDateMs <= currentTimeMs ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOnlyActiveTasks() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialUser("salaboy").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        List allActiveTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allActiveTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allActiveTasks.get(0)).getStatusId().equals("Reserved"));
        QueryFilter queryFilter = new QueryFilter(0, 0);
        HashMap params = new HashMap();
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add(Status.Reserved.toString());
        params.put("statuses", statuses);
        queryFilter.setParams(params);
        List allActiveAuditTasksByUser = this.taskAuditService.getAllAuditTasksByStatus("salaboy", queryFilter);
        Assert.assertEquals((long)1L, (long)allActiveAuditTasksByUser.size());
        Assert.assertTrue((boolean)((AuditTask)allActiveAuditTasksByUser.get(0)).getStatus().equals("Reserved"));
        statuses = new ArrayList();
        statuses.add(Status.Completed.toString());
        params.put("statuses", statuses);
        queryFilter.setParams(params);
        allActiveAuditTasksByUser = this.taskAuditService.getAllAuditTasksByStatus("salaboy", queryFilter);
        Assert.assertEquals((long)0L, (long)allActiveAuditTasksByUser.size());
    }

    @Test
    public void testGroupTasks() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialUser("salaboy").addPotentialUser("krisv").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        List allGroupTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupTasks.get(0)).getStatusId().equals("Ready"));
        List allGroupAuditTasksByUser = this.taskAuditService.getAllGroupAuditTasksByUser("salaboy", new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allGroupAuditTasksByUser.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasksByUser.get(0)).getStatus().equals("Ready"));
    }

    @Test
    public void testAdminTasks() {
        Task task = new TaskFluent().setName("This is my task name").setAdminUser("salaboy").getTask();
        this.taskService.addTask(task, new HashMap());
        List allAdminTasks = this.taskService.getTasksAssignedAsBusinessAdministrator("salaboy", null);
        Assert.assertEquals((long)1L, (long)allAdminTasks.size());
        List allAdminAuditTasksByUser = this.taskAuditService.getAllAdminAuditTasksByUser("salaboy", new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allAdminAuditTasksByUser.size());
    }

    @Test
    public void testExitAfterClaim() {
        Task task = new TaskFluent().setName("This is my task name 2").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.exit(taskId, "Administrator");
        List allHistoryAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allHistoryAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
    }

    @Test
    public void testExitBeforeClaim() {
        Task task = new TaskFluent().setName("This is my task name 2").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.exit(taskId, "Administrator");
        List allHistoryAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allHistoryAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
    }

    private void testDescriptionUpdate(String oldDescription, String newDescription, boolean changeExpected, String expectedMessage) {
        Task task = new TaskFluent().setDescription(oldDescription).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        ArrayList<I18NTextImpl> descriptions = new ArrayList<I18NTextImpl>();
        descriptions.add(new I18NTextImpl("", newDescription));
        this.taskService.setDescriptions(taskId, descriptions);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((String)task.getDescription()).isEqualTo(newDescription);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((String)((AuditTask)auditTasks.get(0)).getDescription()).isEqualTo(newDescription);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).isEqualTo(expectedMessage);
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    @Test
    public void testDescriptionUpdateSame() {
        this.testDescriptionUpdate("description", "description", false, "");
    }

    @Test
    public void testDescriptionUpdateDifferent() {
        this.testDescriptionUpdate("old description", "new description", true, "Updated Description {From: 'old description' to: 'new description'}");
    }

    @Test
    public void testDescriptionUpdateToNull() {
        this.testDescriptionUpdate("old description", null, true, "Updated Description {From: 'old description' to: ''}");
    }

    @Test
    public void testDescriptionUpdateToEmpty() {
        this.testDescriptionUpdate("old description", "", true, "Updated Description {From: 'old description' to: ''}");
    }

    @Test
    public void testDescriptionUpdateFromNull() {
        this.testDescriptionUpdate(null, "new description", true, "Updated Description {From: '' to: 'new description'}");
    }

    @Test
    public void testDescriptionUpdateFromEmpty() {
        this.testDescriptionUpdate("", "new description", true, "Updated Description {From: '' to: 'new description'}");
    }

    private void testNameUpdate(String oldName, String newName, boolean changeExpected, String expectedMessage) {
        Task task = new TaskFluent().setName(oldName).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        ArrayList<I18NTextImpl> taskNames = new ArrayList<I18NTextImpl>();
        taskNames.add(new I18NTextImpl("", newName));
        this.taskService.setTaskNames(taskId, taskNames);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((String)task.getName()).isEqualTo(newName);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((String)((AuditTask)auditTasks.get(0)).getName()).isEqualTo(newName);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).isEqualTo(expectedMessage);
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    @Test
    public void testNameUpdateSame() {
        this.testNameUpdate("name", "name", false, "");
    }

    @Test
    public void testNameUpdateDifferent() {
        this.testNameUpdate("old name", "new name", true, "Updated Name {From: 'old name' to: 'new name'}");
    }

    @Test
    public void testNameUpdateToNull() {
        this.testNameUpdate("old name", null, true, "Updated Name {From: 'old name' to: ''}");
    }

    @Test
    public void testNameUpdateToEmpty() {
        this.testNameUpdate("old name", "", true, "Updated Name {From: 'old name' to: ''}");
    }

    @Test
    public void testNameUpdateFromNull() {
        this.testNameUpdate(null, "new name", true, "Updated Name {From: '' to: 'new name'}");
    }

    @Test
    public void testNameUpdateFromEmpty() {
        this.testNameUpdate("", "new name", true, "Updated Name {From: '' to: 'new name'}");
    }

    private void testPriorityUpdate(int oldPriority, int newPriority, boolean changeExpected) {
        Task task = new TaskFluent().setPriority(oldPriority).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.setPriority(taskId, newPriority);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((Integer)task.getPriority()).isEqualTo(newPriority);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((int)((AuditTask)auditTasks.get(0)).getPriority()).isEqualTo(newPriority);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).isEqualTo("Updated Priority {From: '0' to: '10'}");
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    @Test
    public void testPriorityUpdateSame() {
        this.testPriorityUpdate(0, 0, false);
    }

    @Test
    public void testPriorityUpdateDifferent() {
        this.testPriorityUpdate(0, 10, true);
    }

    private void testDueDateUpdate(Date oldDate, Date newDate, boolean changeExpected, String expectedMessage) {
        Task task = new TaskFluent().setDueDate(oldDate).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.setExpirationDate(taskId, newDate);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((Date)task.getTaskData().getExpirationTime()).isEqualTo((Object)newDate);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((Date)((AuditTask)auditTasks.get(0)).getDueDate()).isEqualTo((Object)newDate);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).isEqualTo(expectedMessage);
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    private Timestamp getToday() {
        return new Timestamp(new Date().getTime());
    }

    private Timestamp getTomorrow() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.getToday());
        c.add(5, 1);
        return new Timestamp(c.getTimeInMillis());
    }

    @Test
    public void testDueDateUpdateSame() {
        this.testDueDateUpdate(this.today, this.today, false, "");
    }

    @Test
    public void testDueDateUpdateDifferent() {
        String fromDate = this.today != null ? new Date(this.today.getTime()).toString() : null;
        String toDate = this.tomorrow != null ? this.tomorrow.toString() : "";
        this.testDueDateUpdate(this.today, this.tomorrow, true, "Updated DueDate {From: '" + fromDate + "' to: '" + toDate + "'}");
    }

    @Test
    public void testDueDateUpdateFromNull() {
        String toDate = this.tomorrow != null ? this.tomorrow.toString() : "";
        this.testDueDateUpdate(null, this.tomorrow, true, "Updated DueDate {From: '' to: '" + toDate + "'}");
    }

    @Test
    public void testDueDateUpdateToNull() {
        String fromDate = this.today != null ? new Date(this.today.getTime()).toString() : null;
        this.testDueDateUpdate(this.today, null, true, "Updated DueDate {From: '" + fromDate + "' to: ''}");
    }

    @Test
    public void testVariableIndexInputAndOutput() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", "updated content");
        outputVariables.put("age", 25);
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)2L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertEquals((Object)"updated content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
    }

    @Test
    public void testVariableIndexInputAndUpdateOutput() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", "updated content");
        outputVariables.put("age", 25);
        this.taskService.addOutputContentFromUser(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)2L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertEquals((Object)"updated content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
        outputVariables = new HashMap();
        outputVariables.put("reply", "completed content");
        outputVariables.put("age", 44);
        outputVariables.put("reason", "rework, please");
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)3L, (long)outputVars.size());
        outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertTrue((boolean)outvars.containsKey("reason"));
        Assert.assertEquals((Object)"completed content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"44", (Object)outvars.get("age"));
        Assert.assertEquals((Object)"rework, please", (Object)outvars.get("reason"));
    }

    @Test
    public void testVariableIndexInputAndOutputWithCustomIdexer() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("person", new Person("john", 25));
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)3L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("person.name"));
        Assert.assertTrue((boolean)vars.containsKey("person.age"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"john", (Object)vars.get("person.name"));
        Assert.assertEquals((Object)"25", (Object)vars.get("person.age"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", "updated content");
        outputVariables.put("person", new Person("mary", 28));
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)3L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)vars.containsKey("person.name"));
        Assert.assertTrue((boolean)vars.containsKey("person.age"));
        Assert.assertEquals((Object)"updated content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"mary", (Object)outvars.get("person.name"));
        Assert.assertEquals((Object)"28", (Object)outvars.get("person.age"));
    }

    @Test
    public void testSearchTasksByVariable() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        List tasksByVariable = this.taskService.taskSummaryQuery("salaboy").variableName(new String[]{"firstVariable"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = this.taskService.taskSummaryQuery("WinterMute").variableName(new String[]{"fistVariable"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = this.taskService.taskSummaryQuery("salaboy").variableName(new String[]{"notexistingVariable"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery("salaboy").regex()).variableName(new String[]{"first*"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
    }

    @Test
    public void testSearchTasksByVariableNameAndValue() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        String userId = "salaboy";
        String varName = "firstVariable";
        String varValue = "string content";
        inputVariables.put(varName, varValue);
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner(userId, null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey(varName));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)varValue, (Object)vars.get(varName));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        List tasksByVariable = ((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).variableName(new String[]{varName}).and()).variableValue(new String[]{varValue}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).variableName(new String[]{varName}).and()).regex()).variableValue(new String[]{"string*"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).regex()).variableName(new String[]{"first*"}).and()).variableValue(new String[]{"string*"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery("WinterMute").regex()).variableName(new String[]{varName}).and()).variableValue(new String[]{varValue}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).regex()).variableName(new String[]{"nonexistingvariable"}).and()).variableValue(new String[]{varValue}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).regex()).variableName(new String[]{varName}).and()).variableValue(new String[]{"updated content"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
    }

    @Test
    public void testVariableIndexInputAndOutputWitlLongText() {
        String reply;
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        String veryLongReply = reply = "Just a short part of the reply";
        for (int i = 0; i < 15; ++i) {
            veryLongReply = veryLongReply + reply;
        }
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", veryLongReply);
        outputVariables.put("age", 25);
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)2L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertEquals((Object)veryLongReply, (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVariableIndexInputAndOutputWitlLongTextTrimmed() {
        System.setProperty("org.jbpm.task.var.log.length", "10");
        try {
            String reply;
            Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
            HashMap<String, Object> inputVariables = new HashMap<String, Object>();
            inputVariables.put("firstVariable", "string content");
            inputVariables.put("number", 1234);
            this.taskService.addTask(task, inputVariables);
            long taskId = task.getId();
            List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
            Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
            Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
            List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
            Assert.assertNotNull((Object)inputVars);
            Assert.assertEquals((long)2L, (long)inputVars.size());
            Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
            Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
            Assert.assertTrue((boolean)vars.containsKey("number"));
            Assert.assertEquals((Object)"string con", (Object)vars.get("firstVariable"));
            Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
            this.taskService.claim(taskId, "Darth Vader");
            allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
            Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
            allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
            Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
            Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
            this.taskService.start(taskId, "Darth Vader");
            Task task1 = this.taskService.getTaskById(taskId);
            Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
            Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
            String veryLongReply = reply = "Just a short part of the reply";
            for (int i = 0; i < 15; ++i) {
                veryLongReply = veryLongReply + reply;
            }
            HashMap<String, Object> outputVariables = new HashMap<String, Object>();
            outputVariables.put("reply", veryLongReply);
            outputVariables.put("age", 25);
            this.taskService.complete(taskId, "Darth Vader", outputVariables);
            List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
            Assert.assertNotNull((Object)outputVars);
            Assert.assertEquals((long)2L, (long)outputVars.size());
            Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
            Assert.assertTrue((boolean)outvars.containsKey("reply"));
            Assert.assertTrue((boolean)outvars.containsKey("age"));
            Assert.assertEquals((Object)"Just a sho", (Object)outvars.get("reply"));
            Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
        }
        finally {
            System.clearProperty("org.jbpm.task.var.log.length");
        }
    }

    @Test
    public void testLifeCycleWithBAM() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.stop(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.complete(taskId, "Darth Vader", null);
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Completed", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Completed");
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        Assertions.assertThat((List)taskEvents).hasSize(8);
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(0)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.ADDED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(0)).getUserId()).isNull();
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(1)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.CLAIMED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(2)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.RELEASED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(2)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(3)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.CLAIMED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(3)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(4)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.STARTED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(4)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(5)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.STOPPED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(5)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(6)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.STARTED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(6)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(7)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.COMPLETED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(7)).getUserId()).isEqualTo("Darth Vader");
    }

    @Test
    public void testLifeCycleWithBAMEndWithExited() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.exit(taskId, "Administrator");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Exited", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Exited");
    }

    @Test
    public void testLifeCycleWithBAMEndWithObsolete() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        ((InternalTaskData)task.getTaskData()).setSkipable(true);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.skip(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Obsolete", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Obsolete");
    }

    @Test
    public void testLifeCycleWithBAMEndWithFailed() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.fail(taskId, "Darth Vader", null);
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Failed", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Failed");
    }

    @Test
    public void testUpdateTaskContentEvents() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.assertAuditTaskInfoGroup("Knights Templer", "Ready", taskId);
        this.taskService.claim(taskId, "Darth Vader");
        this.assertAuditTaskInfo("Darth Vader", "Reserved", taskId);
        this.taskService.start(taskId, "Darth Vader");
        this.assertAuditTaskInfo("Darth Vader", "InProgress", taskId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "value");
        this.taskService.addOutputContentFromUser(taskId, "Darth Vader", params);
        params.clear();
        params.put("test", "updated");
        this.taskService.complete(taskId, "Darth Vader", params);
        this.assertAuditTaskInfo("Darth Vader", "Completed", taskId);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        Assertions.assertThat((List)taskEvents).hasSize(6);
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(0)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.ADDED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(0)).getUserId()).isNull();
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(1)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.CLAIMED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(2)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.STARTED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(2)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(3)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.UPDATED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(3)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(4)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.UPDATED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(4)).getUserId()).isEqualTo("Darth Vader");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(5)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.COMPLETED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(5)).getUserId()).isEqualTo("Darth Vader");
    }

    @Test
    public void testForwardTaskWithMsgEvents() {
        Task task = new TaskFluent().setName("This is my task name").setAdminUser("Administrator").addPotentialUser("Administrator").addPotentialUser("Darth Vader").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.claim(taskId, "Administrator");
        this.assertAuditTaskInfo("Administrator", "Reserved", taskId);
        this.taskService.forward(taskId, "Administrator", "Darth Vader");
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        Assertions.assertThat((List)taskEvents).hasSize(3);
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(0)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.ADDED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(0)).getUserId()).isNull();
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(1)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.CLAIMED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getUserId()).isEqualTo("Administrator");
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(2)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.FORWARDED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(2)).getUserId()).isEqualTo("Administrator");
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(2)).getMessage()).isNotNull();
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(2)).getMessage()).contains(new CharSequence[]{"Darth Vader"});
    }

    @Test
    public void testAddTaskWithEventDate() {
        Task task = new TaskFluent().setName("This is my task name").setAdminUser("Administrator").addPotentialUser("Darth Vader").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        Assertions.assertThat((List)taskEvents).hasSize(1);
        Assertions.assertThat((Comparable)((TaskEvent)taskEvents.get(0)).getType()).isEqualTo((Object)TaskEvent.TaskEventType.ADDED);
        Assertions.assertThat((String)((TaskEvent)taskEvents.get(0)).getUserId()).isNull();
        List allGroupAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        AuditTaskImpl auditTask = (AuditTaskImpl)allGroupAuditTasks.get(0);
        Assert.assertNotNull((Object)auditTask.getLastModificationDate());
    }

    @Test
    public void testPagination() {
        for (int i = 0; i < 10; ++i) {
            Task task = new TaskFluent().setName("My Task " + (i + 1)).addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
            this.taskService.addTask(task, new HashMap());
        }
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, -1));
        Assertions.assertThat((List)auditTasks).hasSize(10);
        auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 0));
        Assertions.assertThat((List)auditTasks).hasSize(10);
        auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 3));
        Assertions.assertThat((List)auditTasks).hasSize(3);
        auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(2, 5));
        Assertions.assertThat((List)auditTasks).hasSize(5);
        Assertions.assertThat((List)auditTasks).extracting(AuditTask::getName).doesNotHaveDuplicates();
    }

    protected Map<String, String> collectVariableNameAndValue(List<TaskVariable> variables) {
        HashMap<String, String> nameValue = new HashMap<String, String>();
        for (TaskVariable taskVar : variables) {
            nameValue.put(taskVar.getName(), taskVar.getValue());
        }
        return nameValue;
    }

    protected void assertBAMTask(long taskId, String expectedStatus) {
        EntityManager em = this.getEntityManager();
        BAMTaskSummaryImpl task = (BAMTaskSummaryImpl)em.createQuery("select bt from BAMTaskSummaryImpl bt where bt.taskId = :taskId").setParameter("taskId", (Object)taskId).getSingleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)taskId, (long)task.getTaskId());
        Assert.assertEquals((Object)expectedStatus, (Object)task.getStatus());
        em.close();
    }

    protected void assertAuditTaskInfoGroup(String group, String status, Long taskId) {
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser(group, new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals(status));
        this.assertBAMTask(taskId, status);
    }

    protected void assertAuditTaskInfo(String user, String status, Long taskId) {
        List allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser(user, new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals(status));
        this.assertBAMTask(taskId, status);
    }

    protected abstract EntityManager getEntityManager();
}

