/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.assertj.core.util.Arrays;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.assignment.AbstractAssignmentTest;
import org.jbpm.services.task.assignment.AssignmentServiceProvider;
import org.jbpm.services.task.assignment.impl.strategy.LoadBalanceAssignmentStrategy;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.services.task.utils.TaskFluent;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalCompletionTimeAssignmentStrategyTest
extends AbstractAssignmentTest {
    private PoolingDataSource pds;
    private EntityManagerFactory emf;
    private Long[] taskIds;
    private static final Logger logger = LoggerFactory.getLogger(TotalCompletionTimeAssignmentStrategyTest.class);
    private static final String DARTH_VADER = "Darth Vader";
    private static final String BOBBA_FET = "Bobba Fet";
    private static final String LUKE_CAGE = "Luke Cage";
    private static final String TONY_STARK = "Tony Stark";
    private static final String DEPLOYMENT_ID = "org.jbpm:jbpm-human-task:7.1.0";
    private static final String PROCESS_ID = "testing tasks";
    private static final Map<String, Object> data = new HashMap<String, Object>();

    private void forceBAMEntries() {
        int waitTime;
        long taskId;
        int count;
        for (count = 0; count < 10; ++count) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).setAdminUser("Administrator").setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID);
            taskId = this.createTaskWithoutAssert(task1);
            waitTime = 100;
            if (count % 3 == 0) {
                waitTime = 230;
            } else if (count % 2 == 0) {
                waitTime = 180;
            }
            this.completeTask(taskId, waitTime);
        }
        for (count = 0; count < 10; ++count) {
            TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).setAdminUser("Administrator").setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID);
            taskId = this.createTaskWithoutAssert(task2);
            waitTime = 1000;
            if (count % 3 == 0) {
                waitTime = 2300;
            } else if (count % 2 == 0) {
                waitTime = 1800;
            }
            this.completeTask(taskId, waitTime);
        }
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.jbpm.task.assignment.enabled", "true");
        System.setProperty("org.jbpm.task.assignment.strategy", "LoadBalance");
        System.setProperty("org.jbpm.task.assignment.loadbalance.calculator", "org.jbpm.services.task.assignment.impl.TotalCompletionTimeLoadCalculator");
        System.setProperty("org.jbpm.services.task.assignment.taskduration.timetolive", "1000");
        this.pds = TotalCompletionTimeAssignmentStrategyTest.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        AssignmentServiceProvider.override((AssignmentStrategy)new LoadBalanceAssignmentStrategy());
        this.taskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).listener((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true)).listener((TaskLifeCycleEventListener)new BAMTaskEventListener(true)).getTaskService();
        this.taskIds = new Long[100];
        this.forceBAMEntries();
    }

    @After
    public void clean() throws Exception {
        System.clearProperty("org.jbpm.task.assignment.enabled");
        System.clearProperty("org.jbpm.task.assignment.strategy");
        System.clearProperty("org.jbpm.task.assignment.loadbalance.calculator");
        AssignmentServiceProvider.clear();
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.pds != null) {
            this.pds.close();
        }
    }

    @Test
    public void testMultipleUser() {
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{BOBBA_FET, DARTH_VADER, LUKE_CAGE});
        for (int x = 0; x < 6; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x % 3]);
        }
        this.completeTask(this.taskIds[1], 500L);
        TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
        this.createAndAssertTask(task2, DARTH_VADER);
        logger.info("testMultipleUser completed");
    }

    @Test
    public void testMultipleUserWithGroup() {
        int x;
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{BOBBA_FET, LUKE_CAGE, TONY_STARK});
        for (x = 0; x < 3; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser(BOBBA_FET).addPotentialGroup("Crusaders").addPotentialUser(LUKE_CAGE).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x]);
        }
        this.completeTask(this.taskIds[1], 1000L);
        expectedOwners = (String[])Arrays.array((Object[])new String[]{LUKE_CAGE, BOBBA_FET, TONY_STARK});
        for (x = 3; x < 6; ++x) {
            TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser(BOBBA_FET).addPotentialGroup("Crusaders").addPotentialUser(LUKE_CAGE).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task2, expectedOwners[x - 3]);
        }
        logger.info("testMultipleUserWithGroup completed");
    }

    @Test
    public void testMultipleUserWithAdd() {
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{BOBBA_FET, DARTH_VADER, LUKE_CAGE, TONY_STARK});
        for (int x = 0; x < 3; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x]);
        }
        this.completeTask(this.taskIds[1], 1000L);
        TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
        this.createAndAssertTask(task2, DARTH_VADER);
        TaskFluent task3 = new TaskFluent().setName("MultiUserLoadBalanceTask3").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).addPotentialUser(TONY_STARK).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
        this.createAndAssertTask(task3, TONY_STARK);
        logger.info("testMultipleUserWithAdd completed");
    }

    @Test
    public void testMultipleUsersWithRemove() {
        int x;
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{BOBBA_FET, DARTH_VADER, LUKE_CAGE, TONY_STARK});
        for (x = 0; x < 4; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser(BOBBA_FET).addPotentialUser(DARTH_VADER).addPotentialUser(LUKE_CAGE).addPotentialUser(TONY_STARK).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x]);
        }
        this.completeTask(this.taskIds[1], 1500L);
        expectedOwners = (String[])Arrays.array((Object[])new String[]{BOBBA_FET, LUKE_CAGE, TONY_STARK});
        for (x = 4; x < 7; ++x) {
            TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser(BOBBA_FET).addPotentialUser(LUKE_CAGE).addPotentialUser(TONY_STARK).setDeploymentID(DEPLOYMENT_ID).setProcessId(PROCESS_ID).setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task2, expectedOwners[x - 4]);
        }
        logger.info("testMultipleUsersWithRemove completed");
    }

    private long createTaskWithoutAssert(TaskFluent tf) {
        Task task = tf.getTask();
        this.taskService.addTask(task, data);
        return task.getId();
    }

    private long createAndAssertTask(TaskFluent tf, String expectedOwner) {
        Task task = tf.getTask();
        this.taskService.addTask(task, data);
        long taskId = task.getId();
        Assert.assertEquals((String)"Owner mismatch", (Object)expectedOwner, (Object)this.taskService.getTaskById(taskId).getTaskData().getActualOwner().getId());
        return taskId;
    }

    private void completeTask(long taskId, long delay) {
        Task task = this.taskService.getTaskById(taskId);
        String owner = task.getTaskData().getActualOwner().getId();
        logger.debug("Starting task {} with user {}", (Object)taskId, (Object)owner);
        this.taskService.start(taskId, owner);
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.taskService.complete(taskId, owner, data);
    }
}

