/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.audit.TaskAuditServiceFactory;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.services.task.utils.TaskFluent;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.InternalTaskService;

public class LocalWithCustomCallbackTaskAuditTest
extends HumanTaskServicesBaseTest {
    private PoolingDataSource pds;
    private EntityManagerFactory emf;
    private NullGroupsUserGroupCallback callback;
    @Inject
    protected TaskAuditService taskAuditService;

    @Before
    public void setup() {
        this.pds = LocalWithCustomCallbackTaskAuditTest.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        this.callback = new NullGroupsUserGroupCallback();
        this.taskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).listener((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true)).listener((TaskLifeCycleEventListener)new BAMTaskEventListener(true)).userGroupCallback((UserGroupCallback)this.callback).getTaskService();
        this.taskAuditService = TaskAuditServiceFactory.newTaskAuditServiceConfigurator().setTaskService((TaskService)this.taskService).getTaskAuditService();
    }

    @After
    public void clean() {
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.pds != null) {
            this.pds.close();
        }
    }

    @Test
    public void testGroupTasks() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialUser("salaboy").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        List allGroupTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupTasks.get(0)).getStatusId().equals("Ready"));
        List allGroupAuditTasksByUser = this.taskAuditService.getAllGroupAuditTasksByUser("salaboy", new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allGroupAuditTasksByUser.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasksByUser.get(0)).getStatus().equals("Ready"));
    }

    private class NullGroupsUserGroupCallback
    implements UserGroupCallback {
        private NullGroupsUserGroupCallback() {
        }

        public boolean existsUser(String userId) {
            return true;
        }

        public boolean existsGroup(String groupId) {
            return true;
        }

        public List<String> getGroupsForUser(String userId) {
            return null;
        }
    }
}

