/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.assertj.core.api.Assertions;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.audit.commands.DeleteAuditEventsCommand;
import org.jbpm.services.task.audit.commands.DeleteBAMTaskSummariesCommand;
import org.jbpm.services.task.audit.commands.GetAuditEventsCommand;
import org.jbpm.services.task.audit.commands.GetBAMTaskSummariesCommand;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.jbpm.services.task.audit.service.objects.Person;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.utils.TaskFluent;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;
import org.kie.internal.task.query.TaskVariableQueryBuilder;

public abstract class TaskAuditBaseTest
extends HumanTaskServicesBaseTest {
    @Inject
    protected TaskAuditService taskAuditService;

    @Test
    public void testComplete() {
        long initTimeMs = new Date().getTime();
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        this.taskService.complete(taskId, "Darth Vader", null);
        Task task2 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task2.getTaskData().getActualOwner().getId());
        List allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand(taskId, new QueryFilter(0, 0)));
        Assert.assertEquals((long)6L, (long)allTaskEvents.size());
        int numFirstTaskEvents = allTaskEvents.size();
        task = new TaskFluent().setName("This is my task name 2").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long secondTaskId = task.getId();
        this.taskService.claim(secondTaskId, "Darth Vader");
        this.taskService.start(secondTaskId, "Darth Vader");
        this.taskService.complete(secondTaskId, "Darth Vader", null);
        allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand());
        int numTaskEvents = allTaskEvents.size();
        Assert.assertTrue((String)("Expected more than " + numFirstTaskEvents + " events: " + numTaskEvents), (numTaskEvents > numFirstTaskEvents ? 1 : 0) != 0);
        this.taskService.execute((Command)new DeleteAuditEventsCommand(taskId));
        allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand());
        Assert.assertEquals((long)(numTaskEvents - numFirstTaskEvents), (long)allTaskEvents.size());
        this.taskService.execute((Command)new DeleteAuditEventsCommand());
        allTaskEvents = (List)this.taskService.execute((Command)new GetAuditEventsCommand());
        Assert.assertEquals((long)0L, (long)allTaskEvents.size());
        List bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand());
        Assert.assertEquals((String)"BAM Task Summary list size: ", (long)2L, (long)bamTaskList.size());
        this.taskService.execute((Command)new DeleteBAMTaskSummariesCommand(taskId));
        bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand());
        Assert.assertEquals((String)("BAM Task Summary list size after delete (task id: " + taskId + ") : "), (long)1L, (long)bamTaskList.size());
        bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand(secondTaskId));
        Assert.assertEquals((String)("BAM Task Summary list size after delete (task id: " + taskId + ") : "), (long)1L, (long)bamTaskList.size());
        this.taskService.execute((Command)new DeleteBAMTaskSummariesCommand());
        bamTaskList = (List)this.taskService.execute((Command)new GetBAMTaskSummariesCommand());
        Assert.assertEquals((String)("BAM Task Summary list size after delete (task id: " + taskId + ") : "), (long)0L, (long)bamTaskList.size());
        List allHistoryAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 0));
        Assert.assertEquals((long)2L, (long)allHistoryAuditTasks.size());
        long currentTimeMs = new Date().getTime();
        for (AuditTask at : allHistoryAuditTasks) {
            Date modDate = ((AuditTaskImpl)at).getLastModificationDate();
            Assert.assertNotNull((Object)modDate);
            long modDateMs = modDate.getTime();
            Assert.assertTrue((String)("Task " + at.getTaskId() + " modification date is not too much in the past"), (modDateMs >= initTimeMs ? 1 : 0) != 0);
            Assert.assertTrue((String)("Task " + at.getTaskId() + " modification date is not in the future"), (modDateMs <= currentTimeMs ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOnlyActiveTasks() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialUser("salaboy").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        List allActiveTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allActiveTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allActiveTasks.get(0)).getStatusId().equals("Reserved"));
        QueryFilter queryFilter = new QueryFilter(0, 0);
        HashMap params = new HashMap();
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add(Status.Reserved.toString());
        params.put("statuses", statuses);
        queryFilter.setParams(params);
        List allActiveAuditTasksByUser = this.taskAuditService.getAllAuditTasksByStatus("salaboy", queryFilter);
        Assert.assertEquals((long)1L, (long)allActiveAuditTasksByUser.size());
        Assert.assertTrue((boolean)((AuditTask)allActiveAuditTasksByUser.get(0)).getStatus().equals("Reserved"));
        statuses = new ArrayList();
        statuses.add(Status.Completed.toString());
        params.put("statuses", statuses);
        queryFilter.setParams(params);
        allActiveAuditTasksByUser = this.taskAuditService.getAllAuditTasksByStatus("salaboy", queryFilter);
        Assert.assertEquals((long)0L, (long)allActiveAuditTasksByUser.size());
    }

    @Test
    public void testGroupTasks() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialUser("salaboy").addPotentialUser("krisv").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        List allGroupTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupTasks.get(0)).getStatusId().equals("Ready"));
        List allGroupAuditTasksByUser = this.taskAuditService.getAllGroupAuditTasksByUser("salaboy", new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allGroupAuditTasksByUser.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasksByUser.get(0)).getStatus().equals("Ready"));
    }

    @Test
    public void testAdminTasks() {
        Task task = new TaskFluent().setName("This is my task name").setAdminUser("salaboy").getTask();
        this.taskService.addTask(task, new HashMap());
        List allAdminTasks = this.taskService.getTasksAssignedAsBusinessAdministrator("salaboy", null);
        Assert.assertEquals((long)1L, (long)allAdminTasks.size());
        List allAdminAuditTasksByUser = this.taskAuditService.getAllAdminAuditTasksByUser("salaboy", new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allAdminAuditTasksByUser.size());
    }

    @Test
    public void testExitAfterClaim() {
        Task task = new TaskFluent().setName("This is my task name 2").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.exit(taskId, "Administrator");
        List allHistoryAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allHistoryAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
    }

    @Test
    public void testExitBeforeClaim() {
        Task task = new TaskFluent().setName("This is my task name 2").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        this.taskService.exit(taskId, "Administrator");
        List allHistoryAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter(0, 0));
        Assert.assertEquals((long)1L, (long)allHistoryAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
    }

    private void testDescriptionUpdate(String oldDescription, String newDescription, boolean changeExpected) {
        Task task = new TaskFluent().setDescription(oldDescription).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        ArrayList<I18NTextImpl> descriptions = new ArrayList<I18NTextImpl>();
        descriptions.add(new I18NTextImpl("", newDescription));
        this.taskService.setDescriptions(taskId, descriptions);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((String)task.getDescription()).isEqualTo((Object)newDescription);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((String)((AuditTask)auditTasks.get(0)).getDescription()).isEqualTo((Object)newDescription);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).contains(new CharSequence[]{String.valueOf(oldDescription), String.valueOf(newDescription)});
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    @Test
    public void testDescriptionUpdateSame() {
        this.testDescriptionUpdate("description", "description", false);
    }

    @Test
    public void testDescriptionUpdateDifferent() {
        this.testDescriptionUpdate("old description", "new description", true);
    }

    @Test
    public void testDescriptionUpdateToNull() {
        this.testDescriptionUpdate("old description", null, true);
    }

    @Test
    public void testDescriptionUpdateToEmpty() {
        this.testDescriptionUpdate("old description", "", true);
    }

    @Test
    public void testDescriptionUpdateFromNull() {
        this.testDescriptionUpdate(null, "new description", true);
    }

    @Test
    public void testDescriptionUpdateFromEmpty() {
        this.testDescriptionUpdate("", "new description", true);
    }

    private void testNameUpdate(String oldName, String newName, boolean changeExpected) {
        Task task = new TaskFluent().setName(oldName).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        ArrayList<I18NTextImpl> taskNames = new ArrayList<I18NTextImpl>();
        taskNames.add(new I18NTextImpl("", newName));
        this.taskService.setTaskNames(taskId, taskNames);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((String)task.getName()).isEqualTo((Object)newName);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((String)((AuditTask)auditTasks.get(0)).getName()).isEqualTo((Object)newName);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).contains(new CharSequence[]{String.valueOf(oldName), String.valueOf(newName)});
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    @Test
    public void testNameUpdateSame() {
        this.testNameUpdate("name", "name", false);
    }

    @Test
    public void testNameUpdateDifferent() {
        this.testNameUpdate("old name", "new name", true);
    }

    @Test
    public void testNameUpdateToNull() {
        this.testNameUpdate("old name", null, true);
    }

    @Test
    public void testNameUpdateToEmpty() {
        this.testNameUpdate("old name", "", true);
    }

    @Test
    public void testNameUpdateFromNull() {
        this.testNameUpdate(null, "new name", true);
    }

    @Test
    public void testNameUpdateFromEmpty() {
        this.testNameUpdate("", "new name", true);
    }

    private void testPriorityUpdate(int oldPriority, int newPriority, boolean changeExpected) {
        Task task = new TaskFluent().setPriority(oldPriority).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.setPriority(taskId, newPriority);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((Integer)task.getPriority()).isEqualTo(newPriority);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((int)((AuditTask)auditTasks.get(0)).getPriority()).isEqualTo(newPriority);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).contains(new CharSequence[]{String.valueOf(oldPriority), String.valueOf(newPriority)});
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    @Test
    public void testPriorityUpdateSame() {
        this.testPriorityUpdate(0, 0, false);
    }

    @Test
    public void testPriorityUpdateDifferent() {
        this.testPriorityUpdate(0, 10, true);
    }

    private void testDueDateUpdate(Date oldDate, Date newDate, boolean changeExpected) {
        Task task = new TaskFluent().setDueDate(oldDate).setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        this.taskService.setExpirationDate(taskId, newDate);
        task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((Date)task.getTaskData().getExpirationTime()).isEqualTo((Object)newDate);
        List auditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assertions.assertThat((List)auditTasks).hasSize(1);
        Assertions.assertThat((Date)((AuditTask)auditTasks.get(0)).getDueDate()).isEqualTo((Object)newDate);
        List taskEvents = this.taskAuditService.getAllTaskEvents(taskId, new QueryFilter());
        if (changeExpected) {
            Assertions.assertThat((List)taskEvents).hasSize(2);
            Assertions.assertThat((String)((TaskEvent)taskEvents.get(1)).getMessage()).contains(new CharSequence[]{String.valueOf(oldDate), String.valueOf(newDate)});
        } else {
            Assertions.assertThat((List)taskEvents).hasSize(1);
        }
    }

    private Timestamp getToday() {
        return new Timestamp(new Date().getTime());
    }

    private Timestamp getTomorrow() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.getToday());
        c.add(5, 1);
        return new Timestamp(c.getTimeInMillis());
    }

    @Test
    public void testDueDateUpdateSame() {
        Timestamp today = this.getToday();
        this.testDueDateUpdate(today, today, false);
    }

    @Test
    public void testDueDateUpdateDifferent() {
        this.testDueDateUpdate(this.getToday(), this.getTomorrow(), true);
    }

    @Test
    public void testDueDateUpdateFromNull() {
        this.testDueDateUpdate(null, this.getTomorrow(), true);
    }

    @Test
    public void testDueDateUpdateToNull() {
        this.testDueDateUpdate(this.getToday(), null, true);
    }

    @Test
    public void testVariableIndexInputAndOutput() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", "updated content");
        outputVariables.put("age", 25);
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)2L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertEquals((Object)"updated content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
    }

    @Test
    public void testVariableIndexInputAndUpdateOutput() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", "updated content");
        outputVariables.put("age", 25);
        this.taskService.addOutputContentFromUser(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)2L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertEquals((Object)"updated content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
        outputVariables = new HashMap();
        outputVariables.put("reply", "completed content");
        outputVariables.put("age", 44);
        outputVariables.put("reason", "rework, please");
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)3L, (long)outputVars.size());
        outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertTrue((boolean)outvars.containsKey("reason"));
        Assert.assertEquals((Object)"completed content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"44", (Object)outvars.get("age"));
        Assert.assertEquals((Object)"rework, please", (Object)outvars.get("reason"));
    }

    @Test
    public void testVariableIndexInputAndOutputWithCustomIdexer() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("person", new Person("john", 25));
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)3L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("person.name"));
        Assert.assertTrue((boolean)vars.containsKey("person.age"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"john", (Object)vars.get("person.name"));
        Assert.assertEquals((Object)"25", (Object)vars.get("person.age"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", "updated content");
        outputVariables.put("person", new Person("mary", 28));
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)3L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)vars.containsKey("person.name"));
        Assert.assertTrue((boolean)vars.containsKey("person.age"));
        Assert.assertEquals((Object)"updated content", (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"mary", (Object)outvars.get("person.name"));
        Assert.assertEquals((Object)"28", (Object)outvars.get("person.age"));
    }

    @Test
    public void testSearchTasksByVariable() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        List tasksByVariable = this.taskService.taskSummaryQuery("salaboy").variableName(new String[]{"firstVariable"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = this.taskService.taskSummaryQuery("WinterMute").variableName(new String[]{"fistVariable"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = this.taskService.taskSummaryQuery("salaboy").variableName(new String[]{"notexistingVariable"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery("salaboy").regex()).variableName(new String[]{"first*"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
    }

    @Test
    public void testSearchTasksByVariableNameAndValue() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        String userId = "salaboy";
        String varName = "firstVariable";
        String varValue = "string content";
        inputVariables.put(varName, varValue);
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner(userId, null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey(varName));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)varValue, (Object)vars.get(varName));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        List tasksByVariable = ((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).variableName(new String[]{varName}).and()).variableValue(new String[]{varValue}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).variableName(new String[]{varName}).and()).regex()).variableValue(new String[]{"string*"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).regex()).variableName(new String[]{"first*"}).and()).variableValue(new String[]{"string*"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)1L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery("WinterMute").regex()).variableName(new String[]{varName}).and()).variableValue(new String[]{varValue}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).regex()).variableName(new String[]{"nonexistingvariable"}).and()).variableValue(new String[]{varValue}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
        tasksByVariable = ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskService.taskSummaryQuery(userId).regex()).variableName(new String[]{varName}).and()).variableValue(new String[]{"updated content"}).build().getResultList();
        Assert.assertNotNull((Object)tasksByVariable);
        Assert.assertEquals((long)0L, (long)tasksByVariable.size());
    }

    @Test
    public void testVariableIndexInputAndOutputWitlLongText() {
        String reply;
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("firstVariable", "string content");
        inputVariables.put("number", 1234);
        this.taskService.addTask(task, inputVariables);
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
        List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
        Assert.assertNotNull((Object)inputVars);
        Assert.assertEquals((long)2L, (long)inputVars.size());
        Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
        Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
        Assert.assertTrue((boolean)vars.containsKey("number"));
        Assert.assertEquals((Object)"string content", (Object)vars.get("firstVariable"));
        Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
        Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
        allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
        this.taskService.start(taskId, "Darth Vader");
        Task task1 = this.taskService.getTaskById(taskId);
        Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
        String veryLongReply = reply = "Just a short part of the reply";
        for (int i = 0; i < 15; ++i) {
            veryLongReply = veryLongReply + reply;
        }
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("reply", veryLongReply);
        outputVariables.put("age", 25);
        this.taskService.complete(taskId, "Darth Vader", outputVariables);
        List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
        Assert.assertNotNull((Object)outputVars);
        Assert.assertEquals((long)2L, (long)outputVars.size());
        Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
        Assert.assertTrue((boolean)outvars.containsKey("reply"));
        Assert.assertTrue((boolean)outvars.containsKey("age"));
        Assert.assertEquals((Object)veryLongReply, (Object)outvars.get("reply"));
        Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVariableIndexInputAndOutputWitlLongTextTrimmed() {
        System.setProperty("org.jbpm.task.var.log.length", "10");
        try {
            String reply;
            Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
            HashMap<String, Object> inputVariables = new HashMap<String, Object>();
            inputVariables.put("firstVariable", "string content");
            inputVariables.put("number", 1234);
            this.taskService.addTask(task, inputVariables);
            long taskId = task.getId();
            List allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
            Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
            Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Ready"));
            List inputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.INPUT}).build().getResultList();
            Assert.assertNotNull((Object)inputVars);
            Assert.assertEquals((long)2L, (long)inputVars.size());
            Map<String, String> vars = this.collectVariableNameAndValue(inputVars);
            Assert.assertTrue((boolean)vars.containsKey("firstVariable"));
            Assert.assertTrue((boolean)vars.containsKey("number"));
            Assert.assertEquals((Object)"string con", (Object)vars.get("firstVariable"));
            Assert.assertEquals((Object)"1234", (Object)vars.get("number"));
            this.taskService.claim(taskId, "Darth Vader");
            allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", null, null, null);
            Assert.assertEquals((long)0L, (long)allGroupAuditTasks.size());
            allGroupAuditTasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", null, null, null);
            Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
            Assert.assertTrue((boolean)((TaskSummary)allGroupAuditTasks.get(0)).getStatusId().equals("Reserved"));
            this.taskService.start(taskId, "Darth Vader");
            Task task1 = this.taskService.getTaskById(taskId);
            Assert.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
            Assert.assertEquals((Object)"Darth Vader", (Object)task1.getTaskData().getActualOwner().getId());
            String veryLongReply = reply = "Just a short part of the reply";
            for (int i = 0; i < 15; ++i) {
                veryLongReply = veryLongReply + reply;
            }
            HashMap<String, Object> outputVariables = new HashMap<String, Object>();
            outputVariables.put("reply", veryLongReply);
            outputVariables.put("age", 25);
            this.taskService.complete(taskId, "Darth Vader", outputVariables);
            List outputVars = ((TaskVariableQueryBuilder)this.taskAuditService.taskVariableQuery().taskId(new long[]{taskId}).intersect()).type(new TaskVariable.VariableType[]{TaskVariable.VariableType.OUTPUT}).build().getResultList();
            Assert.assertNotNull((Object)outputVars);
            Assert.assertEquals((long)2L, (long)outputVars.size());
            Map<String, String> outvars = this.collectVariableNameAndValue(outputVars);
            Assert.assertTrue((boolean)outvars.containsKey("reply"));
            Assert.assertTrue((boolean)outvars.containsKey("age"));
            Assert.assertEquals((Object)"Just a sho", (Object)outvars.get("reply"));
            Assert.assertEquals((Object)"25", (Object)outvars.get("age"));
        }
        finally {
            System.clearProperty("org.jbpm.task.var.log.length");
        }
    }

    @Test
    public void testLifeCycleWithBAM() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.stop(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.complete(taskId, "Darth Vader", null);
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Completed", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Completed");
    }

    @Test
    public void testLifeCycleWithBAMEndWithExited() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.exit(taskId, "Administrator");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasks(new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Exited", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Exited");
    }

    @Test
    public void testLifeCycleWithBAMEndWithObsolete() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        ((InternalTaskData)task.getTaskData()).setSkipable(true);
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.skip(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Obsolete", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Obsolete");
    }

    @Test
    public void testLifeCycleWithBAMEndWithFailed() {
        Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").getTask();
        this.taskService.addTask(task, new HashMap());
        long taskId = task.getId();
        List allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.release(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllGroupAuditTasksByUser("Knights Templer", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertTrue((boolean)((AuditTask)allGroupAuditTasks.get(0)).getStatus().equals("Ready"));
        this.assertBAMTask(taskId, "Ready");
        this.taskService.claim(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Reserved", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Reserved");
        this.taskService.start(taskId, "Darth Vader");
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"InProgress", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "InProgress");
        this.taskService.fail(taskId, "Darth Vader", null);
        allGroupAuditTasks = this.taskAuditService.getAllAuditTasksByUser("Darth Vader", new QueryFilter());
        Assert.assertEquals((long)1L, (long)allGroupAuditTasks.size());
        Assert.assertEquals((Object)"Failed", (Object)((AuditTask)allGroupAuditTasks.get(0)).getStatus());
        this.assertBAMTask(taskId, "Failed");
    }

    protected Map<String, String> collectVariableNameAndValue(List<TaskVariable> variables) {
        HashMap<String, String> nameValue = new HashMap<String, String>();
        for (TaskVariable taskVar : variables) {
            nameValue.put(taskVar.getName(), taskVar.getValue());
        }
        return nameValue;
    }

    protected void assertBAMTask(long taskId, String expectedStatus) {
        EntityManager em = this.getEntityManager();
        BAMTaskSummaryImpl task = (BAMTaskSummaryImpl)em.createQuery("select bt from BAMTaskSummaryImpl bt where bt.taskId = :taskId").setParameter("taskId", (Object)taskId).getSingleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)taskId, (long)task.getTaskId());
        Assert.assertEquals((Object)expectedStatus, (Object)task.getStatus());
        em.close();
    }

    protected abstract EntityManager getEntityManager();
}

