/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.persistence.correlation.JPACorrelationKeyFactory;
import org.jbpm.query.QueryBuilderCoverageTestUtil;
import org.jbpm.services.task.HumanTaskServicesBaseTest;
import org.jbpm.services.task.audit.BAMTaskSummaryQueryBuilder;
import org.jbpm.services.task.audit.service.TaskJPAAuditService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.task.model.Status;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.ExtendedParametrizedQueryBuilder;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.internal.task.query.AuditTaskQueryBuilder;
import org.kie.internal.task.query.TaskEventQueryBuilder;
import org.kie.internal.task.query.TaskVariableQueryBuilder;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAuditQueryBuilderCoverageTest
extends HumanTaskServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(TaskAuditQueryBuilderCoverageTest.class);
    private static PoolingDataSourceWrapper pds;
    private static EntityManagerFactory emf;
    private TaskJPAAuditService auditService;
    private static QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller inputFiller;

    @BeforeClass
    public static void configure() {
        pds = TaskAuditQueryBuilderCoverageTest.setupPoolingDataSource();
        emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        QueryBuilderCoverageTestUtil.hackTheDatabaseMetadataLoggerBecauseTheresALogbackXmlInTheClasspath();
    }

    @Before
    public void setup() {
        this.auditService = new TaskJPAAuditService(emf);
    }

    @AfterClass
    public static void reset() {
        if (emf != null) {
            emf.close();
            emf = null;
        }
        if (pds != null) {
            pds.close();
            pds = null;
        }
    }

    @Test
    public void auditTaskQueryBuilderCoverageTest() {
        AuditTaskQueryBuilder queryBuilder = this.auditService.auditTaskQuery();
        Class<AuditTaskQueryBuilder> builderClass = AuditTaskQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    @Test
    public void taskEventQueryBuilderCoverageTest() {
        TaskEventQueryBuilder queryBuilder = this.auditService.taskEventQuery();
        Class<TaskEventQueryBuilder> builderClass = TaskEventQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    @Test
    public void bamTaskSummaryQueryBuilderCoverageTest() {
        BAMTaskSummaryQueryBuilder queryBuilder = this.auditService.bamTaskSummaryQuery();
        Class<BAMTaskSummaryQueryBuilder> builderClass = BAMTaskSummaryQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    @Test
    public void taskVariableQueryBuilderCoverageTest() {
        TaskVariableQueryBuilder queryBuilder = this.auditService.taskVariableQuery();
        Class<TaskVariableQueryBuilder> builderClass = TaskVariableQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    static {
        inputFiller = new QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller(){
            private final JPACorrelationKeyFactory correlationKeyFactory = new JPACorrelationKeyFactory();
            private int auditTaskOrderByType = 0;
            private int taskEventOrderByType = 0;
            private int bamTaskSummaryOrderByType = 0;
            private int taskVariableOrderByType = 0;
            private int taskVariableType = 0;

            public Object fillInput(Class type) {
                if (type.equals(CorrelationKey.class)) {
                    return this.correlationKeyFactory.newCorrelationKey("business-key");
                }
                if (type.equals(AuditTaskQueryBuilder.OrderBy.class)) {
                    return this.auditTaskOrderByType++ % 2 == 0 ? AuditTaskQueryBuilder.OrderBy.processId : AuditTaskQueryBuilder.OrderBy.processInstanceId;
                }
                if (type.equals(TaskEventQueryBuilder.OrderBy.class)) {
                    int typeCase = this.taskEventOrderByType++ % 3;
                    switch (typeCase) {
                        case 0: {
                            return TaskEventQueryBuilder.OrderBy.logTime;
                        }
                        case 1: {
                            return TaskEventQueryBuilder.OrderBy.processInstanceId;
                        }
                        case 2: {
                            return TaskEventQueryBuilder.OrderBy.taskId;
                        }
                    }
                } else if (type.equals(TaskVariableQueryBuilder.OrderBy.class)) {
                    int typeCase = this.taskVariableOrderByType++ % 4;
                    switch (typeCase) {
                        case 0: {
                            return TaskVariableQueryBuilder.OrderBy.id;
                        }
                        case 1: {
                            return TaskVariableQueryBuilder.OrderBy.processInstanceId;
                        }
                        case 2: {
                            return TaskVariableQueryBuilder.OrderBy.modificationDate;
                        }
                        case 3: {
                            return TaskVariableQueryBuilder.OrderBy.taskId;
                        }
                    }
                } else if (type.equals(BAMTaskSummaryQueryBuilder.OrderBy.class)) {
                    int typeCase = this.bamTaskSummaryOrderByType++ % 6;
                    switch (typeCase) {
                        case 0: {
                            return BAMTaskSummaryQueryBuilder.OrderBy.createdDate;
                        }
                        case 1: {
                            return BAMTaskSummaryQueryBuilder.OrderBy.endDate;
                        }
                        case 2: {
                            return BAMTaskSummaryQueryBuilder.OrderBy.processInstanceId;
                        }
                        case 3: {
                            return BAMTaskSummaryQueryBuilder.OrderBy.startDate;
                        }
                        case 4: {
                            return BAMTaskSummaryQueryBuilder.OrderBy.taskId;
                        }
                        case 5: {
                            return BAMTaskSummaryQueryBuilder.OrderBy.taskName;
                        }
                    }
                } else if (type.isArray()) {
                    Class<?> elemType = type.getComponentType();
                    if (elemType.equals(CorrelationKey.class)) {
                        CorrelationKey[] corrKeyArr = new CorrelationKey[]{this.correlationKeyFactory.newCorrelationKey("key:one"), this.correlationKeyFactory.newCorrelationKey("key:two")};
                        return corrKeyArr;
                    }
                    if (elemType.equals(TaskEvent.TaskEventType.class)) {
                        TaskEvent.TaskEventType[] typeArr = new TaskEvent.TaskEventType[]{TaskEvent.TaskEventType.ACTIVATED, TaskEvent.TaskEventType.ADDED, TaskEvent.TaskEventType.CLAIMED};
                        return typeArr;
                    }
                    if (elemType.equals(Status.class)) {
                        Status[] statusArr = new Status[]{Status.Completed, Status.Suspended};
                        return statusArr;
                    }
                    if (elemType.equals(TaskVariable.VariableType.class)) {
                        TaskVariable.VariableType[] typeArr = new TaskVariable.VariableType[]{this.taskVariableType++ % 2 == 0 ? TaskVariable.VariableType.INPUT : TaskVariable.VariableType.OUTPUT};
                        return typeArr;
                    }
                }
                return null;
            }
        };
    }
}

