/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import org.jbpm.persistence.scripts.PersistenceUnit;
import org.jbpm.persistence.scripts.TestPersistenceContext;
import org.jbpm.persistence.scripts.util.TestsUtil;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class UpgradeScriptsTest {
    private static final String TEST_PROCESS_ID = "minimalProcess";
    private static final Long TEST_PROCESS_INSTANCE_ID = 1L;
    private static final Integer TEST_SESSION_ID = 1;

    @Test
    public void testExecutingScripts() throws IOException, SQLException {
        this.testExecutingScripts("jbpm");
        this.testExecutingScripts("bpms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecutingScripts(String type) throws IOException, SQLException {
        TestsUtil.clearSchema();
        TestPersistenceContext scriptRunnerContext = new TestPersistenceContext();
        scriptRunnerContext.init(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(this.getClass().getResource("/ddl60").getFile()));
            scriptRunnerContext.executeScripts(new File(this.getClass().getResource("/upgrade-scripts").getFile()), type);
        }
        finally {
            scriptRunnerContext.clean();
        }
        TestPersistenceContext dbTestingContext = new TestPersistenceContext();
        dbTestingContext.init(PersistenceUnit.DB_TESTING);
        try {
            dbTestingContext.startAndPersistSomeProcess(TEST_PROCESS_ID);
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 1 ? 1 : 0) != 0);
        }
        finally {
            dbTestingContext.clean();
        }
    }

    @Test
    public void testPersistedProcess() throws IOException, ParseException, SQLException {
        this.testPersistedProcess("jbpm");
        this.testPersistedProcess("bpms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistedProcess(String type) throws IOException, ParseException, SQLException {
        TestsUtil.clearSchema();
        TestPersistenceContext scriptRunnerContext = new TestPersistenceContext();
        scriptRunnerContext.init(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(this.getClass().getResource("/ddl60").getFile()));
            scriptRunnerContext.persistOldProcessAndSession(TEST_SESSION_ID, TEST_PROCESS_ID, TEST_PROCESS_INSTANCE_ID);
            scriptRunnerContext.createSomeTask();
            scriptRunnerContext.executeScripts(new File(this.getClass().getResource("/upgrade-scripts").getFile()), type);
        }
        finally {
            scriptRunnerContext.clean();
        }
        TestPersistenceContext dbTestingContext = new TestPersistenceContext();
        dbTestingContext.init(PersistenceUnit.DB_TESTING);
        try {
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((dbTestingContext.getStoredSessionsCount() == 1 ? 1 : 0) != 0);
            StatefulKnowledgeSession persistedSession = dbTestingContext.loadPersistedSession(TEST_SESSION_ID.longValue(), TEST_PROCESS_ID);
            Assert.assertNotNull((Object)persistedSession);
            persistedSession.startProcess(TEST_PROCESS_ID);
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 2 ? 1 : 0) != 0);
            ProcessInstance processInstance = persistedSession.getProcessInstance(TEST_PROCESS_INSTANCE_ID.longValue());
            Assert.assertNotNull((Object)processInstance);
            persistedSession.signalEvent("test", null);
            processInstance = persistedSession.getProcessInstance(TEST_PROCESS_INSTANCE_ID.longValue());
            Assert.assertNull((Object)processInstance);
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 0 ? 1 : 0) != 0);
            persistedSession.dispose();
            persistedSession.destroy();
            Assert.assertTrue((dbTestingContext.getStoredSessionsCount() == 0 ? 1 : 0) != 0);
        }
        finally {
            dbTestingContext.clean();
        }
    }
}

