/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.api.integration.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionSynchronization;
import org.jbpm.persistence.api.integration.EventCollection;
import org.jbpm.persistence.api.integration.EventEmitter;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.persistence.api.integration.PersistenceEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalPersistenceEventManager
implements PersistenceEventManager {
    private static final Logger logger = LoggerFactory.getLogger(TransactionalPersistenceEventManager.class);
    private static final String EVENT_COLLECTION = "org.jbpm.integration.events";
    protected TransactionManager tm = TransactionManagerFactory.get().newTransactionManager();
    private EventEmitter emitter;

    public TransactionalPersistenceEventManager() {
        ServiceLoader<EventEmitter> found = ServiceLoader.load(EventEmitter.class);
        Iterator<EventEmitter> it = found.iterator();
        if (it.hasNext()) {
            this.emitter = it.next();
            logger.debug("EventEmitter {} was found and is going to be used", (Object)this.emitter);
        }
    }

    @Override
    public void create(InstanceView<?> item) {
        if (!this.isActive()) {
            return;
        }
        EventCollection collection = this.getCollection();
        collection.add(item);
    }

    @Override
    public void update(InstanceView<?> item) {
        if (!this.isActive()) {
            return;
        }
        EventCollection collection = this.getCollection();
        collection.update(item);
    }

    @Override
    public void delete(InstanceView<?> item) {
        if (!this.isActive()) {
            return;
        }
        EventCollection collection = this.getCollection();
        collection.remove(item);
    }

    @Override
    public boolean isActive() {
        return this.emitter != null;
    }

    protected EventCollection getCollection() {
        EventCollection collection = (EventCollection)this.tm.getResource((Object)EVENT_COLLECTION);
        if (collection == null) {
            collection = this.emitter.newCollection();
            this.tm.putResource((Object)EVENT_COLLECTION, (Object)collection);
            this.registerSync();
        }
        return collection;
    }

    protected void registerSync() {
        try {
            this.tm.registerTransactionSynchronization(new TransactionSynchronization(){
                private Collection<InstanceView<?>> events;

                public void beforeCompletion() {
                    EventCollection collection = (EventCollection)TransactionalPersistenceEventManager.this.tm.getResource((Object)TransactionalPersistenceEventManager.EVENT_COLLECTION);
                    logger.debug("About to deliver {} to emitter {}", (Object)collection, (Object)TransactionalPersistenceEventManager.this.emitter);
                    Collection<InstanceView<?>> data = collection.getEvents();
                    this.events = data.stream().map(event -> {
                        event.copyFromSource();
                        return event;
                    }).collect(Collectors.toSet());
                    TransactionalPersistenceEventManager.this.emitter.deliver(this.events);
                    logger.debug("Collection {} delivered to {}", (Object)collection, (Object)TransactionalPersistenceEventManager.this.emitter);
                }

                public void afterCompletion(int status) {
                    if (status == 0) {
                        logger.debug("Completed successfull so applying events on emitter {}", (Object)TransactionalPersistenceEventManager.this.emitter);
                        TransactionalPersistenceEventManager.this.emitter.apply(this.events);
                        logger.debug("Emitter {} successfully applied events", (Object)TransactionalPersistenceEventManager.this.emitter);
                    } else {
                        logger.debug("Failed at completion so dropping events on emitter {}", (Object)TransactionalPersistenceEventManager.this.emitter);
                        TransactionalPersistenceEventManager.this.emitter.drop(this.events);
                        logger.debug("Emitter {} successfully dropped events", (Object)TransactionalPersistenceEventManager.this.emitter);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Unable to register transaction synchronization for event handling due to {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void close() {
        if (!this.isActive()) {
            return;
        }
        this.emitter.close();
    }
}

