/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.api.integration.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.persistence.api.integration.EventCollection;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.persistence.api.integration.base.BaseEventCollection;
import org.jbpm.persistence.api.integration.model.TaskInstanceView;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

public class BaseEventCollectionTest {
    @Test
    public void testEqualsEvents() {
        BaseEventCollection events = new BaseEventCollection();
        MyTaskImpl task1 = new MyTaskImpl(1L, "javi", 1000, "alguno", "variado", new MyTaskDataImpl(), (PeopleAssignments)new MyPeople(new MyUser("javi")), "mucho espanol");
        events.add((InstanceView)new TaskInstanceView((Task)task1));
        MyTaskImpl task2 = new MyTaskImpl(1L, "javi", 1000, "alguno", "variado", new MyTaskDataImpl(), (PeopleAssignments)new MyPeople(new MyUser("javi")), "poco espanol");
        events.add((InstanceView)new TaskInstanceView((Task)task2));
        Assert.assertEquals((Object)task1, (Object)task2);
        Assert.assertEquals((long)1L, (long)events.getEvents().size());
        Assert.assertEquals((Object)"poco espanol", (Object)((TaskInstanceView)events.getEvents().iterator().next()).getDescription());
    }

    @Test
    public void testNewSerialization() throws IOException, ClassNotFoundException {
        BaseEventCollection events = new BaseEventCollection();
        MyTaskImpl task1 = new MyTaskImpl(1L, "javi", 1000, "alguno", "variado", new MyTaskDataImpl(), (PeopleAssignments)new MyPeople(new MyUser("javi")), "mucho espanol");
        events.add((InstanceView)new TaskInstanceView((Task)task1));
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try (ObjectOutputStream objectStream = new ObjectOutputStream(byteArray);){
            objectStream.writeObject(events);
        }
        this.assertValidCollection(BaseEventCollectionTest.readObject(new ByteArrayInputStream(byteArray.toByteArray())));
    }

    @Test
    public void testOldVersionDeserialization() throws ClassNotFoundException, IOException {
        this.assertValidCollection(BaseEventCollectionTest.readObject(this.getClass().getClassLoader().getResourceAsStream("BaseEventCollection.ser")));
    }

    private void assertValidCollection(EventCollection collection) {
        Collection events = collection.getEvents();
        Assert.assertFalse((boolean)events.isEmpty());
        TaskInstanceView view = (TaskInstanceView)events.iterator().next();
        Assert.assertEquals((long)1L, (long)view.getId());
        Assert.assertEquals((Object)"javi", (Object)view.getName());
        Assert.assertEquals((long)1000L, (long)view.getPriority().intValue());
        Assert.assertEquals((Object)"alguno", (Object)view.getSubject());
        Assert.assertEquals((Object)"variado", (Object)view.getFormName());
        Assert.assertEquals((Object)"mucho espanol", (Object)view.getDescription());
    }

    private static EventCollection readObject(InputStream input) throws IOException, ClassNotFoundException {
        try (ObjectInputStream stream = new ObjectInputStream(input);){
            EventCollection eventCollection = (EventCollection)stream.readObject();
            return eventCollection;
        }
    }

    private static class MyUser
    implements User {
        private String id;

        public String getId() {
            return this.id;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.id);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readUTF();
        }

        public MyUser(String id) {
            this.id = id;
        }

        public String toString() {
            return "MyUser [id=" + this.id + "]";
        }
    }

    private static class MyPeople
    implements InternalPeopleAssignments {
        private User user;

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.user);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.user = (User)in.readObject();
        }

        public User getTaskInitiator() {
            return this.user;
        }

        public List<OrganizationalEntity> getPotentialOwners() {
            return Collections.emptyList();
        }

        public List<OrganizationalEntity> getBusinessAdministrators() {
            return Collections.emptyList();
        }

        public String toString() {
            return "MyPeople [user=" + this.user + "]";
        }

        public MyPeople(User user) {
            this.user = user;
        }

        public void setTaskInitiator(User taskInitiator) {
        }

        public void setPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        }

        public List<OrganizationalEntity> getExcludedOwners() {
            return Collections.emptyList();
        }

        public void setExcludedOwners(List<OrganizationalEntity> excludedOwners) {
        }

        public List<OrganizationalEntity> getTaskStakeholders() {
            return Collections.emptyList();
        }

        public void setTaskStakeholders(List<OrganizationalEntity> taskStakeholders) {
        }

        public void setBusinessAdministrators(List<OrganizationalEntity> businessAdministrators) {
        }

        public List<OrganizationalEntity> getRecipients() {
            return Collections.emptyList();
        }

        public void setRecipients(List<OrganizationalEntity> recipients) {
        }
    }

    private static class MyTaskDataImpl
    implements TaskData {
        private MyTaskDataImpl() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public Status getStatus() {
            return Status.Completed;
        }

        public Status getPreviousStatus() {
            return null;
        }

        public User getActualOwner() {
            return null;
        }

        public User getCreatedBy() {
            return null;
        }

        public Date getCreatedOn() {
            return null;
        }

        public Date getActivationTime() {
            return null;
        }

        public Date getExpirationTime() {
            return null;
        }

        public boolean isSkipable() {
            return false;
        }

        public long getWorkItemId() {
            return 0L;
        }

        public long getProcessInstanceId() {
            return 0L;
        }

        public String getProcessId() {
            return null;
        }

        public String getDeploymentId() {
            return null;
        }

        public long getProcessSessionId() {
            return 0L;
        }

        public String getDocumentType() {
            return null;
        }

        public long getDocumentContentId() {
            return 0L;
        }

        public String getOutputType() {
            return null;
        }

        public Long getOutputContentId() {
            return null;
        }

        public String getFaultName() {
            return null;
        }

        public String getFaultType() {
            return null;
        }

        public long getFaultContentId() {
            return 0L;
        }

        public List<Comment> getComments() {
            return null;
        }

        public List<Attachment> getAttachments() {
            return null;
        }

        public long getParentId() {
            return 0L;
        }

        public Map<String, Object> getTaskInputVariables() {
            return null;
        }

        public Map<String, Object> getTaskOutputVariables() {
            return null;
        }
    }

    private static class MyTaskImpl
    implements Task {
        private Long id;
        private String name;
        private Integer priority;
        private String subject;
        private String formName;
        private TaskData taskData;
        private PeopleAssignments peopleAssigments;
        private String description;

        public MyTaskImpl(Long id, String name, Integer priority, String subject, String formName, TaskData taskData, PeopleAssignments peopleAssigments, String description) {
            this.id = id;
            this.name = name;
            this.priority = priority;
            this.subject = subject;
            this.formName = formName;
            this.taskData = taskData;
            this.peopleAssigments = peopleAssigments;
            this.description = description;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.id);
            out.writeUTF(this.name);
            out.writeInt(this.priority);
            out.writeUTF(this.subject);
            out.writeUTF(this.formName);
            out.writeObject(this.taskData);
            out.writeObject(this.peopleAssigments);
            out.writeUTF(this.description);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readLong();
            this.name = in.readUTF();
            this.priority = in.readInt();
            this.subject = in.readUTF();
            this.formName = in.readUTF();
            this.taskData = (TaskData)in.readObject();
            this.peopleAssigments = (PeopleAssignments)in.readObject();
            this.description = in.readUTF();
        }

        public String toString() {
            return "MyTaskImpl [id=" + this.id + ", name=" + this.name + ", priority=" + this.priority + ", subject=" + this.subject + ", formName=" + this.formName + ", taskData=" + this.taskData + ", peopleAssigments=" + this.peopleAssigments + ", description=" + this.description + "]";
        }

        public Long getId() {
            return this.id;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public List<I18NText> getNames() {
            return Collections.emptyList();
        }

        public List<I18NText> getSubjects() {
            return Collections.emptyList();
        }

        public List<I18NText> getDescriptions() {
            return Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getDescription() {
            return this.description;
        }

        public PeopleAssignments getPeopleAssignments() {
            return this.peopleAssigments;
        }

        public TaskData getTaskData() {
            return this.taskData;
        }

        public String getTaskType() {
            return "alwaysTheSame";
        }

        public Boolean isArchived() {
            return false;
        }

        public Integer getVersion() {
            return 1;
        }

        public String getFormName() {
            return this.formName;
        }

        public int hashCode() {
            return this.id.intValue();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyTaskImpl)) {
                return false;
            }
            MyTaskImpl other = (MyTaskImpl)obj;
            return this.id.longValue() == other.id.longValue();
        }
    }
}

