/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import gnu.trove.list.linked.TByteLinkedList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class BlobUserType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public int hashCode(Object x) throws HibernateException {
        if (x == null) {
            return 0;
        }
        if (x instanceof byte[]) {
            byte[] xArr = (byte[])x;
            return Arrays.hashCode(xArr);
        }
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        Blob blob = resultSet.getBlob(names[0]);
        if (blob == null) {
            return null;
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value != null) {
            BlobImpl blob = new BlobImpl((byte[])value);
            st.setBlob(index, blob);
        } else {
            st.setNull(index, this.sqlTypes()[0]);
        }
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    private class BlobImpl
    implements Blob {
        private TByteLinkedList blobInfo = new TByteLinkedList();

        public BlobImpl() {
        }

        BlobImpl(byte[] bytes) {
            this.blobInfo.add(bytes);
        }

        public long length() throws SQLException {
            return this.blobInfo.size();
        }

        public byte[] getBytes(long pos, int length) throws SQLException {
            byte[] result = new byte[length];
            this.blobInfo.toArray(result, (int)pos - 1, length);
            return result;
        }

        public int setBytes(long pos, byte[] bytes) throws SQLException {
            if (pos + (long)bytes.length > (long)this.blobInfo.size()) {
                if (pos > (long)this.blobInfo.size()) {
                    this.blobInfo.add(new byte[(int)pos - this.blobInfo.size()]);
                }
                this.blobInfo.add(new byte[(int)(pos + (long)bytes.length) - this.blobInfo.size()]);
            }
            this.blobInfo.set((int)pos, bytes);
            return bytes.length;
        }

        public InputStream getBinaryStream(long offset, long length) throws SQLException {
            byte[] output = new byte[(int)length];
            System.arraycopy(this.blobInfo.toArray(), (int)offset, output, 0, (int)length);
            return new ByteArrayInputStream(output);
        }

        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this.blobInfo.toArray());
        }

        public long position(byte[] pattern, long start) throws SQLException {
            int pos = this.blobInfo.indexOf(pattern[0]);
            while (pos != -1) {
                int pat;
                for (pat = 0; this.blobInfo.get(pos + pat) == pattern[pat] && pat < pattern.length; ++pat) {
                }
                if (pat == pattern.length) {
                    return pos;
                }
                int lastPos = pos;
                if ((pos = this.blobInfo.subList(pos, this.blobInfo.size()).indexOf(pattern[0])) <= 0) continue;
                pos += lastPos;
            }
            return pos;
        }

        public long position(Blob pattern, long start) throws SQLException {
            byte[] patternBytes = this.toByteArray(pattern);
            return this.position(patternBytes, start);
        }

        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            if ((long)this.blobInfo.size() < pos + (long)len) {
                int size = (int)(pos + (long)len) - this.blobInfo.size();
                this.blobInfo.add(new byte[size]);
            }
            this.blobInfo.set(offset, bytes, offset, len);
            return len;
        }

        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw new UnsupportedOperationException("Unable to create binary stream for writing to blob");
        }

        public void truncate(long len) throws SQLException {
            byte[] contents = this.blobInfo.toArray();
            this.blobInfo.clear();
            byte[] newContents = new byte[(int)len];
            System.arraycopy(contents, 0, newContents, 0, (int)len);
            this.blobInfo.add(newContents);
        }

        public void free() throws SQLException {
            this.blobInfo.clear();
            this.blobInfo = null;
        }

        private byte[] toByteArray(Blob blob) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                return this.toByteArrayImpl(blob, baos);
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] toByteArrayImpl(Blob fromImageBlob, ByteArrayOutputStream baos) throws SQLException, IOException {
            byte[] buf = new byte[4096];
            InputStream is = fromImageBlob.getBinaryStream();
            try {
                int dataSize;
                while ((dataSize = is.read(buf)) != -1) {
                    baos.write(buf, 0, dataSize);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            return baos.toByteArray();
        }
    }
}

