/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.apache.log4j.xml.DOMConfigurator;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.TimerJobFactoryType;
import org.drools.command.runtime.process.CompleteWorkItemCommand;
import org.drools.command.runtime.process.GetProcessInstanceCommand;
import org.drools.command.runtime.process.StartProcessCommand;
import org.drools.compiler.PackageBuilder;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.jpa.JpaJDKTimerService;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManagerFactory;
import org.drools.process.core.Work;
import org.drools.process.core.impl.WorkImpl;
import org.drools.rule.Package;
import org.jbpm.compiler.ProcessBuilderImpl;
import org.jbpm.persistence.JbpmTestCase;
import org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory;
import org.jbpm.persistence.processinstance.JPASignalManagerFactory;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.junit.After;
import org.junit.Test;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.command.Command;
import org.kie.definition.KnowledgePackage;
import org.kie.definition.process.Node;
import org.kie.definition.process.Process;
import org.kie.runtime.Environment;
import org.kie.runtime.KieSessionConfiguration;
import org.kie.runtime.conf.KieSessionOption;
import org.kie.runtime.conf.TimerJobFactoryOption;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItem;

public class SingleSessionCommandServiceTest
extends JbpmTestCase {
    private HashMap<String, Object> context;
    private Environment env;

    public void setUp() {
        String testMethodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.context = testMethodName.startsWith("testPersistenceTimer") ? PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa", false) : PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testPersistenceWorkItems() throws Exception {
        this.setUp();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KieSessionConfiguration)config, this.env);
        int sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
        service.dispose();
    }

    @Test
    public void testPersistenceWorkItemsUserTransaction() throws Exception {
        this.setUp();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KieSessionConfiguration)config, this.env);
        int sessionId = service.getSessionId();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        ut.commit();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        ut.commit();
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
        service.dispose();
    }

    private Collection<KnowledgePackage> getProcessWorkItems() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode2 = new WorkItemNode();
        workItemNode2.setId(4L);
        workItemNode2.setName("WorkItem2");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode2.setWork((Work)work);
        process.addNode((Node)workItemNode2);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)workItemNode2, "DROOLS_DEFAULT");
        WorkItemNode workItemNode3 = new WorkItemNode();
        workItemNode3.setId(5L);
        workItemNode3.setName("WorkItem3");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode3.setWork((Work)work);
        process.addNode((Node)workItemNode3);
        new ConnectionImpl((Node)workItemNode2, "DROOLS_DEFAULT", (Node)workItemNode3, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode3, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)new KnowledgePackageImp(packageBuilder.getPackage()));
        return list;
    }

    @Test
    public void testPersistenceSubProcess() {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = this.getProcessSubProcess();
        ruleBase.addPackage(pkg);
        SingleSessionCommandService service = new SingleSessionCommandService(ruleBase, config, this.env);
        int sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        long processInstanceId = processInstance.getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), ruleBase, config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        Collection nodeInstances = processInstance.getNodeInstances();
        SingleSessionCommandServiceTest.assertEquals((int)1, (int)nodeInstances.size());
        SubProcessNodeInstance subProcessNodeInstance = (SubProcessNodeInstance)nodeInstances.iterator().next();
        long subProcessInstanceId = subProcessNodeInstance.getProcessInstanceId();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        RuleFlowProcessInstance subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)subProcessInstance);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), ruleBase, config, this.env);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), ruleBase, config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)subProcessInstance);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
        service.dispose();
    }

    private Package getProcessSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(3L);
        subProcessNode.setName("SubProcess");
        subProcessNode.setProcessId("org.drools.test.SubProcess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        process = new RuleFlowProcess();
        process.setId("org.drools.test.SubProcess");
        process.setName("SubProcess");
        process.setPackageName("org.drools.test");
        start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    @Test
    public void testPersistenceTimer() throws Exception {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        config.setOption((KieSessionOption)TimerJobFactoryOption.get((String)TimerJobFactoryType.JPA.getId()));
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KieSessionConfiguration)config, this.env);
        int sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        Thread.sleep(500L);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        Thread.sleep(5000L);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("2000");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)new KnowledgePackageImp(packageBuilder.getPackage()));
        return list;
    }

    @Test
    public void testPersistenceTimer2() throws Exception {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        config.setOption((KieSessionOption)TimerJobFactoryOption.get((String)TimerJobFactoryType.JPA.getId()));
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer2();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KieSessionConfiguration)config, this.env);
        int sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        Thread.sleep(2000L);
        service = new SingleSessionCommandService(Integer.valueOf(sessionId), kbase, (KieSessionConfiguration)config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer2() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("0");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("try { Thread.sleep(1000); } catch (Throwable t) {} System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)new KnowledgePackageImp(packageBuilder.getPackage()));
        return list;
    }

    static {
        DOMConfigurator.configure((URL)SingleSessionCommandServiceTest.class.getResource("/log4j.xml"));
    }
}

