/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import junit.framework.Assert;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.jbpm.marshalling.util.MarshallingTestUtil;
import org.kie.KieBase;

@Entity
@SequenceGenerator(name="marshalledDataIdSeq", sequenceName="MARSHALLEDDATA_ID_SEQ")
public class MarshalledData {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="marshalledDataIdSeq")
    public Integer id;
    @Lob
    public byte[] byteArray;
    @Lob
    public byte[] serializedKnowledgeBase;
    public String testMethodName;
    public Integer snapshotNumber;
    public String marshalledObjectClassName;
    public Long marshalledObjectId;
    @Transient
    private static HashMap<String, AtomicInteger> testMethodSnapshotNumMap = new HashMap();

    public MarshalledData() {
    }

    public MarshalledData(Object marshalledClassInstance) {
        this.testMethodName = MarshallingTestUtil.getTestMethodName();
        this.initializeObject(marshalledClassInstance);
    }

    public MarshalledData(String testMethodName, Object marshalledClassInstance) {
        this.testMethodName = testMethodName != null ? MarshallingTestUtil.getTestMethodName() : testMethodName;
        this.initializeObject(marshalledClassInstance);
    }

    private void initializeObject(Object marshalledClassInstance) {
        String className;
        if (testMethodSnapshotNumMap.get(this.testMethodName) == null) {
            testMethodSnapshotNumMap.put(this.testMethodName, new AtomicInteger(-1));
        }
        this.snapshotNumber = testMethodSnapshotNumMap.get(this.testMethodName).incrementAndGet();
        this.marshalledObjectClassName = className = marshalledClassInstance.getClass().getName();
        if (className.equals(SessionInfo.class.getName())) {
            SessionInfo sessionInfo = (SessionInfo)marshalledClassInstance;
            this.byteArray = sessionInfo.getData();
            this.marshalledObjectId = sessionInfo.getId().longValue();
            if (MarshallingTestUtil.STORE_KNOWLEDGE_BASE) {
                try {
                    this.storeAssociatedKnowledgeBase(sessionInfo);
                }
                catch (IOException ioe) {
                    Assert.fail((String)("Unable to retrieve marshalled data or id for " + className + " object: [" + ioe.getClass().getSimpleName() + ", " + ioe.getMessage()));
                }
            }
        } else if (className.equals(WorkItemInfo.class.getName())) {
            WorkItemInfo workItemInfo = (WorkItemInfo)marshalledClassInstance;
            this.byteArray = MarshallingTestUtil.getWorkItemByteArray(workItemInfo);
            this.marshalledObjectId = workItemInfo.getId();
        } else if ("org.jbpm.persistence.processinstance.ProcessInstanceInfo".equals(className)) {
            Class<?> processInstanceInfoClass = null;
            try {
                this.byteArray = MarshallingTestUtil.getProcessInstanceInfoByteArray(marshalledClassInstance);
                processInstanceInfoClass = Class.forName(className);
                Method getIdMethod = processInstanceInfoClass.getMethod("getId", null);
                Object idObject = getIdMethod.invoke(marshalledClassInstance, (Object[])null);
                this.marshalledObjectId = (Long)idObject;
            }
            catch (Exception e) {
                Assert.fail((String)("Unable to retrieve marshalled data or id for " + className + " object: [" + e.getClass().getSimpleName() + ", " + e.getMessage()));
            }
        }
    }

    private void storeAssociatedKnowledgeBase(SessionInfo sessionInfo) throws IOException {
        KieBase kbase = sessionInfo.getJPASessionMashallingHelper().getKbase();
        this.serializedKnowledgeBase = DroolsStreamUtils.streamOut((Object)kbase);
    }

    public static Integer getCurrentTestMethodSnapshotNumber() {
        String testMethodName = MarshallingTestUtil.getTestMethodName();
        if (testMethodSnapshotNumMap.get(testMethodName) != null) {
            return testMethodSnapshotNumMap.get(testMethodName).intValue();
        }
        return null;
    }

    public String getTestMethodAndSnapshotNum() {
        return this.testMethodName + ":" + this.snapshotNumber;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append((this.id != null ? this.id : "") + ":");
        if (this.byteArray != null) {
            string.append(MarshallingTestUtil.byteArrayHashCode(this.byteArray));
        }
        string.append(":");
        string.append((this.testMethodName != null ? this.testMethodName : "") + ":");
        string.append((this.snapshotNumber != null ? this.snapshotNumber : "") + ":");
        string.append((this.marshalledObjectClassName != null ? this.marshalledObjectClassName : "") + ":");
        string.append(this.marshalledObjectId != null ? this.marshalledObjectId : "");
        return string.toString();
    }
}

