/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.process.CorrelationKey;
import org.kie.process.CorrelationProperty;

public class JpaProcessPersistenceContext
extends JpaPersistenceContext
implements ProcessPersistenceContext {
    public JpaProcessPersistenceContext(EntityManager em) {
        super(em);
    }

    @Override
    public void persist(ProcessInstanceInfo processInstanceInfo) {
        this.getEntityManager().persist((Object)processInstanceInfo);
    }

    @Override
    public ProcessInstanceInfo findProcessInstanceInfo(Long processId) {
        return (ProcessInstanceInfo)this.getEntityManager().find(ProcessInstanceInfo.class, (Object)processId);
    }

    @Override
    public void remove(ProcessInstanceInfo processInstanceInfo) {
        this.getEntityManager().remove((Object)processInstanceInfo);
        List correlations = this.getEntityManager().createNamedQuery("GetCorrelationKeysByProcessInstanceId").setParameter("pId", (Object)processInstanceInfo.getId()).getResultList();
        if (correlations != null) {
            for (CorrelationKeyInfo key : correlations) {
                this.getEntityManager().remove((Object)key);
            }
        }
    }

    @Override
    public List<Long> getProcessInstancesWaitingForEvent(String type) {
        Query processInstancesForEvent = this.getEntityManager().createNamedQuery("ProcessInstancesWaitingForEvent");
        processInstancesForEvent.setFlushMode(FlushModeType.COMMIT);
        processInstancesForEvent.setParameter("type", (Object)type);
        return processInstancesForEvent.getResultList();
    }

    @Override
    public void persist(CorrelationKeyInfo correlationKeyInfo) {
        Long processInstanceId = this.getProcessInstanceByCorrelationKey(correlationKeyInfo);
        if (processInstanceId != null) {
            throw new RuntimeException(correlationKeyInfo + " already exists");
        }
        this.getEntityManager().persist((Object)correlationKeyInfo);
    }

    @Override
    public Long getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        Query processInstancesForEvent = this.getEntityManager().createNamedQuery("GetProcessInstanceIdByCorrelation");
        processInstancesForEvent.setFlushMode(FlushModeType.COMMIT);
        processInstancesForEvent.setParameter("elem_count", (Object)correlationKey.getProperties().size());
        ArrayList<Object> properties = new ArrayList<Object>();
        for (CorrelationProperty property : correlationKey.getProperties()) {
            properties.add(property.getValue());
        }
        processInstancesForEvent.setParameter("properties", properties);
        try {
            return (Long)processInstancesForEvent.getSingleResult();
        }
        catch (NonUniqueResultException e) {
            return null;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

