/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContextManager;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.process.CorrelationKey;

public class JPAProcessInstanceManager
implements ProcessInstanceManager {
    private InternalKnowledgeRuntime kruntime;
    private volatile transient Map<Long, ProcessInstance> processInstances = new ConcurrentHashMap<Long, ProcessInstance>();

    public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public void addProcessInstance(ProcessInstance processInstance, CorrelationKey correlationKey) {
        ProcessInstanceInfo processInstanceInfo = new ProcessInstanceInfo(processInstance, this.kruntime.getEnvironment());
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        context.persist(processInstanceInfo);
        ((org.jbpm.process.instance.ProcessInstance)processInstance).setId(processInstanceInfo.getId().longValue());
        processInstanceInfo.updateLastReadDate();
        if (correlationKey != null) {
            CorrelationKeyInfo correlationKeyInfo = (CorrelationKeyInfo)correlationKey;
            correlationKeyInfo.setProcessInstanceId(processInstanceInfo.getId());
            context.persist(correlationKeyInfo);
        }
        this.internalAddProcessInstance(processInstance);
    }

    public void internalAddProcessInstance(ProcessInstance processInstance) {
        if (((ConcurrentHashMap)this.processInstances).putIfAbsent(processInstance.getId(), processInstance) != null) {
            throw new ConcurrentModificationException("Duplicate process instance [" + processInstance.getProcessId() + "/" + processInstance.getId() + "]" + " added to process instance manager.");
        }
    }

    public ProcessInstance getProcessInstance(long id) {
        return this.getProcessInstance(id, false);
    }

    public ProcessInstance getProcessInstance(long id, boolean readOnly) {
        org.jbpm.process.instance.ProcessInstance processInstance = null;
        processInstance = (org.jbpm.process.instance.ProcessInstance)this.processInstances.get(id);
        if (processInstance != null) {
            return processInstance;
        }
        ProcessPersistenceContextManager ppcm = (ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
        ppcm.beginCommandScopedEntityManager();
        ProcessPersistenceContext context = ppcm.getProcessPersistenceContext();
        ProcessInstanceInfo processInstanceInfo = context.findProcessInstanceInfo(id);
        if (processInstanceInfo == null) {
            return null;
        }
        if (!readOnly) {
            processInstanceInfo.updateLastReadDate();
        }
        if (((ProcessInstanceImpl)(processInstance = (org.jbpm.process.instance.ProcessInstance)processInstanceInfo.getProcessInstance(this.kruntime, this.kruntime.getEnvironment(), readOnly))).getProcessXml() == null) {
            Process process = this.kruntime.getKieBase().getProcess(processInstance.getProcessId());
            if (process == null) {
                throw new IllegalArgumentException("Could not find process " + processInstance.getProcessId());
            }
            processInstance.setProcess(process);
        }
        if (processInstance.getKnowledgeRuntime() == null) {
            Long parentProcessInstanceId = (Long)((ProcessInstanceImpl)processInstance).getMetaData().get("ParentProcessInstanceId");
            if (parentProcessInstanceId != null) {
                this.kruntime.getProcessInstance(parentProcessInstanceId.longValue());
            }
            processInstance.setKnowledgeRuntime(this.kruntime);
            ((ProcessInstanceImpl)processInstance).reconnect();
        }
        return processInstance;
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return Collections.unmodifiableCollection(this.processInstances.values());
    }

    public void removeProcessInstance(ProcessInstance processInstance) {
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        ProcessInstanceInfo processInstanceInfo = context.findProcessInstanceInfo(processInstance.getId());
        if (processInstanceInfo != null) {
            context.remove(processInstanceInfo);
        }
        this.internalRemoveProcessInstance(processInstance);
    }

    public void internalRemoveProcessInstance(ProcessInstance processInstance) {
        this.processInstances.remove(processInstance.getId());
    }

    public void clearProcessInstances() {
        for (ProcessInstance processInstance : new ArrayList<ProcessInstance>(this.processInstances.values())) {
            ((ProcessInstanceImpl)processInstance).disconnect();
        }
    }

    public void clearProcessInstancesState() {
        TimerManager timerManager = ((InternalProcessRuntime)this.kruntime.getProcessRuntime()).getTimerManager();
        for (ProcessInstance processInstance : new ArrayList<ProcessInstance>(this.processInstances.values())) {
            WorkflowProcessInstance pi = (WorkflowProcessInstance)processInstance;
            for (NodeInstance nodeInstance : pi.getNodeInstances()) {
                List timerIds;
                if (!(nodeInstance instanceof StateBasedNodeInstance) || (timerIds = ((StateBasedNodeInstance)nodeInstance).getTimerInstances()) == null) continue;
                for (Long id : timerIds) {
                    timerManager.cancelTimer(id.longValue());
                }
            }
        }
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        Long processInstanceId = context.getProcessInstanceByCorrelationKey(correlationKey);
        if (processInstanceId == null) {
            return null;
        }
        return this.getProcessInstance(processInstanceId);
    }
}

