/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.map.impl;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.persistence.map.impl.MapPersistenceTest;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class JpaBasedPersistenceTest
extends MapPersistenceTest {
    private HashMap<String, Object> context;
    private EntityManagerFactory emf;
    private JtaTransactionManager txm;
    private boolean useTransactions = false;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        if (PersistenceUtil.useTransactions()) {
            this.useTransactions = true;
            Environment env = PersistenceUtil.createEnvironment(this.context);
            Object tm = env.get("org.kie.transaction.TransactionManager");
            this.txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
        }
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Override
    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    @Override
    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, int ksessionId, KnowledgeBase kbase) {
        ksession.dispose();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    @Override
    protected int getProcessInstancesCount() {
        boolean txOwner = false;
        if (this.useTransactions) {
            txOwner = this.txm.begin();
        }
        int size = this.emf.createEntityManager().createQuery("FROM ProcessInstanceInfo").getResultList().size();
        if (this.useTransactions) {
            this.txm.commit(txOwner);
        }
        return size;
    }

    @Override
    protected int getKnowledgeSessionsCount() {
        boolean transactionOwner = false;
        if (this.useTransactions) {
            transactionOwner = this.txm.begin();
        }
        int size = this.emf.createEntityManager().createQuery("FROM SessionInfo").getResultList().size();
        if (this.useTransactions) {
            this.txm.commit(transactionOwner);
        }
        return size;
    }
}

