/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.HashMap;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.transaction.UserTransaction;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.jbpm.persistence.processinstance.objects.NonSerializableClass;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceResolverStrategyTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceResolverStrategyTest.class);
    private HashMap<String, Object> context;
    private StatefulKnowledgeSession ksession;
    private static final String RF_FILE = "SimpleProcess.rf";
    private static final String PROCESS_ID = "org.jbpm.persistence.TestProcess";
    private static final String VAR_NAME = "persistVar";

    @Before
    public void before() {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        Environment env = PersistenceUtil.createEnvironment(this.context);
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new ProcessInstanceResolverStrategy(), new JPAPlaceholderResolverStrategy(env), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KnowledgeBase kbase = this.loadKnowledgeBase();
        this.ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        Assert.assertTrue((String)"Valid KnowledgeSession could not be created.", (this.ksession != null && this.ksession.getId() > 0 ? 1 : 0) != 0);
    }

    private KnowledgeBase loadKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource(RF_FILE), ResourceType.DRF);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        return kbase;
    }

    @After
    public void after() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testWithDatabaseAndStartProcess() throws Exception {
        HashMap<String, NonSerializableClass> params = new HashMap<String, NonSerializableClass>();
        NonSerializableClass processVar = new NonSerializableClass();
        processVar.setString("1234567890");
        params.put(VAR_NAME, processVar);
        params.put("logger", (NonSerializableClass)logger);
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        em.setFlushMode(FlushModeType.COMMIT);
        em.joinTransaction();
        em.persist((Object)processVar);
        em.close();
        ut.commit();
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS_ID, params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        processVar = (NonSerializableClass)((WorkflowProcessInstance)processInstance).getVariable(VAR_NAME);
        Assert.assertNotNull((Object)processVar);
    }

    @Test
    public void testWithDatabaseAndStartProcessInstance() throws Exception {
        HashMap<String, NonSerializableClass> params = new HashMap<String, NonSerializableClass>();
        NonSerializableClass processVar = new NonSerializableClass();
        processVar.setString("1234567890");
        params.put(VAR_NAME, processVar);
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        EntityManager em = emf.createEntityManager();
        em.setFlushMode(FlushModeType.COMMIT);
        em.joinTransaction();
        em.persist((Object)processVar);
        em.close();
        ut.commit();
        ProcessInstance processInstance = this.ksession.createProcessInstance(PROCESS_ID, params);
        long processInstanceId = processInstance.getId();
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)processInstance.getState());
        this.ksession.insert((Object)processInstance);
        this.ksession.startProcessInstance(processInstanceId);
        this.ksession.fireAllRules();
        processInstance = this.ksession.getProcessInstance(processInstanceId);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        processVar = (NonSerializableClass)((WorkflowProcessInstance)processInstance).getVariable(VAR_NAME);
        Assert.assertNotNull((Object)processVar);
    }
}

