/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.MapBasedPersistenceContext;
import org.jbpm.persistence.NonTransactionalProcessPersistentSession;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.ProcessStorage;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.internal.process.CorrelationKey;

public class MapBasedProcessPersistenceContext
extends MapBasedPersistenceContext
implements ProcessPersistenceContext,
NonTransactionalProcessPersistentSession {
    private ProcessStorage storage;
    private Map<Long, ProcessInstanceInfo> processes;
    private Map<CorrelationKeyInfo, ProcessInstanceInfo> processInstancesByBusinessKey;

    public MapBasedProcessPersistenceContext(ProcessStorage storage) {
        super((KnowledgeSessionStorage)storage);
        this.storage = storage;
        this.processes = new HashMap<Long, ProcessInstanceInfo>();
        this.processInstancesByBusinessKey = new HashMap<CorrelationKeyInfo, ProcessInstanceInfo>();
    }

    @Override
    public void persist(ProcessInstanceInfo processInstanceInfo) {
        if (processInstanceInfo.getId() == null) {
            processInstanceInfo.setId(this.storage.getNextProcessInstanceId());
        }
        this.processes.put(processInstanceInfo.getId(), processInstanceInfo);
    }

    @Override
    public ProcessInstanceInfo findProcessInstanceInfo(Long processId) {
        ProcessInstanceInfo processInstanceInfo = this.processes.get(processId);
        if (processInstanceInfo == null) {
            processInstanceInfo = this.storage.findProcessInstanceInfo(processId);
        }
        return processInstanceInfo;
    }

    @Override
    public List<ProcessInstanceInfo> getStoredProcessInstances() {
        return Collections.unmodifiableList(new ArrayList<ProcessInstanceInfo>(this.processes.values()));
    }

    public void close() {
        super.close();
        this.clearStoredProcessInstances();
    }

    @Override
    public void remove(ProcessInstanceInfo processInstanceInfo) {
        this.storage.removeProcessInstanceInfo(processInstanceInfo.getId());
    }

    @Override
    public List<Long> getProcessInstancesWaitingForEvent(String type) {
        return this.storage.getProcessInstancesWaitingForEvent(type);
    }

    @Override
    public void clearStoredProcessInstances() {
        this.processes.clear();
    }

    @Override
    public void persist(CorrelationKeyInfo correlationKeyInfo) {
        ProcessInstanceInfo piInfo = this.processes.get(correlationKeyInfo.getProcessInstanceId());
        if (piInfo != null) {
            this.processInstancesByBusinessKey.put(correlationKeyInfo, piInfo);
        }
    }

    @Override
    public Long getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        ProcessInstanceInfo piInfo = this.processInstancesByBusinessKey.get(correlationKey);
        return piInfo.getId();
    }
}

