/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.timer;

import org.drools.core.command.CommandService;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.persistence.jpa.JDKCallableJobCommand;
import org.drools.persistence.jpa.JpaTimerJobInstance;
import org.jbpm.persistence.timer.GlobalJPATimerJobFactoryManager;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.kie.api.command.Command;

public class GlobalJpaTimerJobInstance
extends JpaTimerJobInstance {
    private static final long serialVersionUID = -5383556604449217342L;
    private String timerServiceId;

    public GlobalJpaTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        super(job, ctx, trigger, handle, scheduler);
        this.timerServiceId = ((GlobalTimerService)scheduler).getTimerServiceId();
    }

    public Void call() throws Exception {
        CommandService commandService = null;
        try {
            JDKCallableJobCommand command = new JDKCallableJobCommand((JpaTimerJobInstance)this);
            if (this.scheduler == null) {
                this.scheduler = (InternalSchedulerService)TimerServiceRegistry.getInstance().get(this.timerServiceId);
            }
            commandService = ((GlobalTimerService)this.scheduler).getCommandService(this.getJobContext());
            commandService.execute((Command)command);
            GlobalJPATimerJobFactoryManager timerService = (GlobalJPATimerJobFactoryManager)((GlobalTimerService)this.scheduler).getTimerJobFactoryManager();
            timerService.removeTimerJobInstance(((DefaultJobHandle)this.getJobHandle()).getTimerJobInstance());
            Void void_ = null;
            return void_;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (commandService != null && commandService instanceof GlobalTimerService.DisposableCommandService) {
                ((GlobalTimerService.DisposableCommandService)commandService).dispose();
            }
        }
    }

    private Integer getSessionIdFromContext() {
        JobContext context = this.getJobContext();
        if (this.getJobContext() instanceof SelfRemovalJobContext) {
            context = ((SelfRemovalJobContext)this.getJobContext()).getJobContext();
        }
        if (context instanceof TimerManager.ProcessJobContext) {
            return ((TimerManager.ProcessJobContext)context).getSessionId();
        }
        return -1;
    }
}

