/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMarshaller;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProcessInstanceMarshaller;
import org.jbpm.marshalling.impl.ProcessMarshallerRegistry;
import org.jbpm.marshalling.impl.ProtobufRuleFlowProcessInstanceMarshaller;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;

@Entity
@SequenceGenerator(name="processInstanceInfoIdSeq", sequenceName="PROCESS_INSTANCE_INFO_ID_SEQ")
public class ProcessInstanceInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="processInstanceInfoIdSeq")
    @Column(name="InstanceId")
    private Long processInstanceId;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private String processId;
    private Date startDate;
    private Date lastReadDate;
    private Date lastModificationDate;
    private int state;
    @Lob
    @Column(length=0x7FFFFFFF)
    byte[] processInstanceByteArray;
    @ElementCollection
    @CollectionTable(name="EventTypes", joinColumns={@JoinColumn(name="InstanceId")})
    @Column(name="element")
    private Set<String> eventTypes = new HashSet<String>();
    @Transient
    ProcessInstance processInstance;
    @Transient
    Environment env;

    protected ProcessInstanceInfo() {
    }

    public ProcessInstanceInfo(ProcessInstance processInstance) {
        this.processInstance = processInstance;
        this.processId = processInstance.getProcessId();
        this.startDate = new Date();
    }

    public ProcessInstanceInfo(ProcessInstance processInstance, Environment env) {
        this(processInstance);
        this.env = env;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getId() {
        return this.processInstanceId;
    }

    public void setId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public Date getLastReadDate() {
        return this.lastReadDate;
    }

    public void updateLastReadDate() {
        Date updateTo = new Date();
        this.lastReadDate = this.lastReadDate == null || updateTo.after(this.lastReadDate) ? updateTo : new Date(this.lastReadDate.getTime() + 1L);
    }

    public int getState() {
        return this.state;
    }

    public ProcessInstance getProcessInstance(InternalKnowledgeRuntime kruntime, Environment env) {
        return this.getProcessInstance(kruntime, env, false);
    }

    public ProcessInstance getProcessInstance(InternalKnowledgeRuntime kruntime, Environment env, boolean readOnly) {
        this.env = env;
        if (this.processInstance == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.processInstanceByteArray);
                MarshallerReaderContext context = new MarshallerReaderContext((InputStream)bais, (InternalRuleBase)((InternalKnowledgeBase)kruntime.getKieBase()).getRuleBase(), null, null, ProtobufMarshaller.TIMER_READERS, this.env);
                ProcessInstanceMarshaller marshaller = this.getMarshallerFromContext(context);
                context.wm = ((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory();
                this.processInstance = marshaller.readProcessInstance(context);
                ((WorkflowProcessInstanceImpl)this.processInstance).setPersisted(false);
                if (readOnly) {
                    ((WorkflowProcessInstanceImpl)this.processInstance).disconnect();
                }
                context.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("IOException while loading process instance: " + e.getMessage(), e);
            }
        }
        return this.processInstance;
    }

    private ProcessInstanceMarshaller getMarshallerFromContext(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        String processInstanceType = stream.readUTF();
        return ProcessMarshallerRegistry.INSTANCE.getMarshaller(processInstanceType);
    }

    private void saveProcessInstanceType(MarshallerWriteContext context, ProcessInstance processInstance, String processInstanceType) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeUTF(processInstanceType);
    }

    @PreUpdate
    public void update() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean variablesChanged = false;
        try {
            MarshallerWriteContext context = new MarshallerWriteContext((OutputStream)baos, null, null, null, null, this.env);
            String processType = ((ProcessInstanceImpl)this.processInstance).getProcess().getType();
            this.saveProcessInstanceType(context, this.processInstance, processType);
            ProcessInstanceMarshaller marshaller = ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType);
            Object result = marshaller.writeProcessInstance(context, this.processInstance);
            if (marshaller instanceof ProtobufRuleFlowProcessInstanceMarshaller && result != null) {
                JBPMMessages.ProcessInstance _instance = (JBPMMessages.ProcessInstance)result;
                PersisterHelper.writeToStreamWithHeader((MarshallerWriteContext)context, (Message)_instance);
            }
            context.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while storing process instance " + this.processInstance.getId() + ": " + e.getMessage(), e);
        }
        byte[] newByteArray = baos.toByteArray();
        if (variablesChanged || !Arrays.equals(newByteArray, this.processInstanceByteArray)) {
            this.state = this.processInstance.getState();
            this.lastModificationDate = new Date();
            this.processInstanceByteArray = newByteArray;
            this.eventTypes.clear();
            for (String type : this.processInstance.getEventTypes()) {
                this.eventTypes.add(type);
            }
        }
        ((WorkflowProcessInstanceImpl)this.processInstance).setPersisted(true);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceInfo other = (ProcessInstanceInfo)obj;
        if (!(this.processInstanceId == other.processInstanceId || this.processInstanceId != null && this.processInstanceId.equals(other.processInstanceId))) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (!(this.startDate == other.startDate || this.startDate != null && this.startDate.equals(other.startDate))) {
            return false;
        }
        if (!(this.lastReadDate == other.lastReadDate || this.lastReadDate != null && this.lastReadDate.equals(other.lastReadDate))) {
            return false;
        }
        if (!(this.lastModificationDate == other.lastModificationDate || this.lastModificationDate != null && this.lastModificationDate.equals(other.lastModificationDate))) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (!Arrays.equals(this.processInstanceByteArray, other.processInstanceByteArray)) {
            return false;
        }
        if (!(this.eventTypes == other.eventTypes || this.eventTypes != null && ((Object)this.eventTypes).equals(other.eventTypes))) {
            return false;
        }
        if (!(this.processInstance == other.processInstance || this.processInstance != null && this.processInstance.equals(other.processInstance))) {
            return false;
        }
        return this.env == other.env || this.env != null && this.env.equals(other.env);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.processInstanceId != null ? this.processInstanceId.hashCode() : 0);
        hash = 61 * hash + this.version;
        hash = 61 * hash + (this.processId != null ? this.processId.hashCode() : 0);
        hash = 61 * hash + (this.startDate != null ? this.startDate.hashCode() : 0);
        hash = 61 * hash + (this.lastReadDate != null ? this.lastReadDate.hashCode() : 0);
        hash = 61 * hash + (this.lastModificationDate != null ? this.lastModificationDate.hashCode() : 0);
        hash = 61 * hash + this.state;
        hash = 61 * hash + Arrays.hashCode(this.processInstanceByteArray);
        hash = 61 * hash + (this.eventTypes != null ? ((Object)this.eventTypes).hashCode() : 0);
        hash = 61 * hash + (this.processInstance != null ? this.processInstance.hashCode() : 0);
        hash = 61 * hash + (this.env != null ? this.env.hashCode() : 0);
        return hash;
    }

    public int getVersion() {
        return this.version;
    }

    public Set<String> getEventTypes() {
        return this.eventTypes;
    }

    public byte[] getProcessInstanceByteArray() {
        return this.processInstanceByteArray;
    }

    public void clearProcessInstance() {
        this.processInstance = null;
    }

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }
}

