/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.jbpm.persistence.session.objects.MyEntity;
import org.jbpm.persistence.session.objects.MyEntityMethods;
import org.jbpm.persistence.session.objects.MyEntityOnlyFields;
import org.jbpm.persistence.session.objects.MySubEntity;
import org.jbpm.persistence.session.objects.MySubEntityMethods;
import org.jbpm.persistence.session.objects.MyVariableExtendingSerializable;
import org.jbpm.persistence.session.objects.MyVariableSerializable;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class VariablePersistenceStrategyTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(VariablePersistenceStrategyTest.class);
    private HashMap<String, Object> context;
    private EntityManagerFactory emf;

    public VariablePersistenceStrategyTest(boolean locking) {
        this.useLocking = locking;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testExtendingInterfaceVariablePersistence() throws Exception {
        Environment env = this.createEnvironment();
        String processId = "extendingInterfaceVariablePersistence";
        String variableText = "my extending serializable variable text";
        KnowledgeBase kbase = this.getKnowledgeBaseForExtendingInterfaceVariablePersistence(processId, variableText);
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        HashMap<String, MyVariableExtendingSerializable> initialParams = new HashMap<String, MyVariableExtendingSerializable>();
        initialParams.put("x", new MyVariableExtendingSerializable(variableText));
        long processInstanceId = ksession.startProcess(processId, initialParams).getId();
        ksession = this.reloadSession(ksession, kbase, env);
        long workItemId = TestWorkItemHandler.getInstance().getWorkItem().getId();
        ksession.getWorkItemManager().completeWorkItem(workItemId, null);
        junit.framework.Assert.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    private KnowledgeBase getKnowledgeBaseForExtendingInterfaceVariablePersistence(String processId, final String variableText) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("x");
        ObjectDataType extendingSerializableDataType = new ObjectDataType();
        extendingSerializableDataType.setClassName(MyVariableExtendingSerializable.class.getName());
        variable.setType((DataType)extendingSerializableDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("workItemNode");
        workItemNode.setId(2L);
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                junit.framework.Assert.assertEquals((String)variableText, (String)((MyVariableExtendingSerializable)context.getVariable("x")).getText());
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(3L);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(4L);
        this.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        this.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)actionNode);
        this.connect((org.jbpm.workflow.core.Node)actionNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)workItemNode);
        process.addNode((Node)actionNode);
        process.addNode((Node)endNode);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ((KnowledgeBaseImpl)kbase).addProcess((Process)process);
        return kbase;
    }

    @Test
    public void testPersistenceVariables() throws NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        if (utx.getStatus() == 6) {
            utx.begin();
            em.joinTransaction();
        }
        int origNumMyEntities = em.createQuery("select i from MyEntity i").getResultList().size();
        int origNumMyEntityMethods = em.createQuery("select i from MyEntityMethods i").getResultList().size();
        int origNumMyEntityOnlyFields = em.createQuery("select i from MyEntityOnlyFields i").getResultList().size();
        if (utx.getStatus() == 0) {
            utx.commit();
        }
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        utx.begin();
        em.joinTransaction();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        utx.commit();
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VariablePersistenceStrategyProcess.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        logger.debug("### Starting process ###");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        List result = this.emf.createEntityManager().createQuery("select i from MyEntity i").getResultList();
        Assert.assertEquals((long)(origNumMyEntities + 1), (long)result.size());
        result = this.emf.createEntityManager().createQuery("select i from MyEntityMethods i").getResultList();
        Assert.assertEquals((long)(origNumMyEntityMethods + 1), (long)result.size());
        result = this.emf.createEntityManager().createQuery("select i from MyEntityOnlyFields i").getResultList();
        Assert.assertEquals((long)(origNumMyEntityOnlyFields + 1), (long)result.size());
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertNull((Object)processInstance.getVariable("a"));
        Assert.assertNull((Object)processInstance.getVariable("b"));
        Assert.assertNull((Object)processInstance.getVariable("c"));
        logger.debug("### Completing first work item ###");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some new String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a new test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a new test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.debug("### Completing second work item ###");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some changed String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a changed test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a changed test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.debug("### Completing third work item ###");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceVariablesWithTypeChange() throws NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        int s = utx.getStatus();
        if (utx.getStatus() == 6) {
            utx.begin();
        }
        em.joinTransaction();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        if (utx.getStatus() == 0) {
            utx.commit();
        }
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VariablePersistenceStrategyProcessTypeChange.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testPersistenceVariablesSubProcess() throws NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        utx.begin();
        em.joinTransaction();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        utx.commit();
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VariablePersistenceStrategySubProcess.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testWorkItemWithVariablePersistence() throws Exception {
        MyEntity myEntity = new MyEntity("This is a test Entity");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        utx.begin();
        em.joinTransaction();
        em.persist((Object)myEntity);
        utx.commit();
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VPSProcessWithWorkItems.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        logger.debug("### Starting process ###");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertNull((Object)processInstance.getVariable("a"));
        Assert.assertNull((Object)processInstance.getVariable("b"));
        Assert.assertNull((Object)processInstance.getVariable("c"));
        logger.debug("### Completing first work item ###");
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("zeta", processInstance.getVariable("z"));
        results.put("equis", processInstance.getVariable("x") + "->modifiedResult");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        logger.debug("######## Getting the already Persisted Variables #########");
        Assert.assertEquals((Object)"SomeString->modifiedResult", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some new String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a new test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a new test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.debug("### Completing second work item ###");
        results = new HashMap();
        results.put("zeta", processInstance.getVariable("z"));
        results.put("equis", processInstance.getVariable("x"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString->modifiedResult", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some changed String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a changed test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a changed test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
        logger.debug("### Completing third work item ###");
        results = new HashMap();
        results.put("zeta", processInstance.getVariable("z"));
        results.put("equis", processInstance.getVariable("x"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testEntityWithSuperClassAnnotationField() throws Exception {
        MySubEntity subEntity = new MySubEntity();
        subEntity.setId(3L);
        Assert.assertEquals((Object)3L, (Object)JPAPlaceholderResolverStrategy.getClassIdValue((Object)subEntity));
    }

    @Test
    public void testEntityWithSuperClassAnnotationMethod() throws Exception {
        MySubEntityMethods subEntity = new MySubEntityMethods();
        subEntity.setId(3L);
        Assert.assertEquals((Object)3L, (Object)JPAPlaceholderResolverStrategy.getClassIdValue((Object)subEntity));
    }

    @Test
    public void testAbortWorkItemWithVariablePersistence() throws Exception {
        MyEntity myEntity = new MyEntity("This is a test Entity");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = this.emf.createEntityManager();
        UserTransaction utx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        utx.begin();
        em.joinTransaction();
        em.persist((Object)myEntity);
        utx.commit();
        em.close();
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.createKnowledgeBase("VPSProcessWithWorkItems.rf");
        StatefulKnowledgeSession ksession = this.createSession(kbase, env);
        logger.debug("### Starting process ###");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("z", myVariableSerializable);
        long processInstanceId = ksession.startProcess("com.sample.ruleflow", parameters).getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertNull((Object)processInstance.getVariable("a"));
        Assert.assertNull((Object)processInstance.getVariable("b"));
        Assert.assertNull((Object)processInstance.getVariable("c"));
        logger.debug("### Completing first work item ###");
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("zeta", processInstance.getVariable("z"));
        results.put("equis", processInstance.getVariable("x") + "->modifiedResult");
        ksession.getWorkItemManager().abortWorkItem(workItem.getId());
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        logger.debug("### Retrieving process instance ###");
        ksession = this.reloadSession(ksession, kbase, env);
        processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        logger.debug("######## Getting the already Persisted Variables #########");
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertEquals((Object)"Some new String", (Object)processInstance.getVariable("a"));
        Assert.assertEquals((Object)"This is a new test Entity", (Object)((MyEntity)processInstance.getVariable("b")).getTest());
        Assert.assertEquals((Object)"This is a new test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("c")).getText());
    }

    private StatefulKnowledgeSession createSession(KnowledgeBase kbase, Environment env) {
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    private StatefulKnowledgeSession reloadSession(StatefulKnowledgeSession ksession, KnowledgeBase kbase, Environment env) {
        long sessionId = ksession.getIdentifier();
        ksession.dispose();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kbase, null, (Environment)env);
    }

    private KnowledgeBase createKnowledgeBase(String flowFile) {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        conf.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add((Resource)new ClassPathResource(flowFile), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            StringBuilder errorMessage = new StringBuilder();
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                errorMessage.append(error.getMessage());
                errorMessage.append(System.getProperty("line.separator"));
            }
            Assert.fail((String)errorMessage.toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private Environment createEnvironment() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new JPAPlaceholderResolverStrategy(env), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        return env;
    }

    private void connect(org.jbpm.workflow.core.Node sourceNode, org.jbpm.workflow.core.Node targetNode) {
        new ConnectionImpl((Node)sourceNode, "DROOLS_DEFAULT", (Node)targetNode, "DROOLS_DEFAULT");
    }
}

