/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.List;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContextManager;
import org.jbpm.process.core.async.AsyncSignalEventCommand;
import org.jbpm.process.instance.event.DefaultSignalManager;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPASignalManager
extends DefaultSignalManager {
    private static final String ASYNC_SIGNAL_PREFIX = "ASYNC-";
    private static final Logger logger = LoggerFactory.getLogger(JPASignalManager.class);

    public JPASignalManager(InternalKnowledgeRuntime kruntime) {
        super(kruntime);
    }

    public void signalEvent(String type, Object event) {
        String actualSignalType = type.replaceFirst(ASYNC_SIGNAL_PREFIX, "");
        ProcessPersistenceContextManager contextManager = (ProcessPersistenceContextManager)this.getKnowledgeRuntime().getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
        ProcessPersistenceContext context = contextManager.getProcessPersistenceContext();
        List<Long> processInstancesToSignalList = context.getProcessInstancesWaitingForEvent(actualSignalType);
        if (type.startsWith(ASYNC_SIGNAL_PREFIX)) {
            RuntimeManager runtimeManager = (RuntimeManager)this.getKnowledgeRuntime().getEnvironment().get("RuntimeManager");
            ExecutorService executorService = (ExecutorService)this.getKnowledgeRuntime().getEnvironment().get("ExecutorService");
            if (runtimeManager != null && executorService != null) {
                for (Long processInstanceId : processInstancesToSignalList) {
                    CommandContext ctx = new CommandContext();
                    ctx.setData("DeploymentId", (Object)runtimeManager.getIdentifier());
                    ctx.setData("ProcessInstanceId", (Object)processInstanceId);
                    ctx.setData("Signal", (Object)actualSignalType);
                    ctx.setData("Event", event);
                    executorService.scheduleRequest(AsyncSignalEventCommand.class.getName(), ctx);
                }
                return;
            }
            logger.warn("Signal should be sent asynchronously but there is no executor service available, continuing sync...");
        }
        for (long id : processInstancesToSignalList) {
            try {
                this.getKnowledgeRuntime().getProcessInstance(id);
            }
            catch (IllegalStateException e) {
            }
            catch (RuntimeException e) {
                logger.warn("Exception when loading process instance for signal '{}', instance with id {} will not be signaled", (Object)e.getMessage(), (Object)id);
            }
        }
        super.signalEvent(actualSignalType, event);
    }
}

