/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.settings;

import java.lang.reflect.Method;
import org.jbpm.persistence.settings.JpaSettings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JpaSettings.class})
public class JpaSettingsTest {
    JpaSettings jpaSettings;

    @Before
    public void setUp() {
        System.clearProperty("org.kie.ds.jndi");
        this.jpaSettings = (JpaSettings)PowerMockito.spy((Object)JpaSettings.get());
    }

    @Test
    public void testReadFromPersistenceXml() {
        String jndiName = this.jpaSettings.getDataSourceJndiName();
        Assert.assertEquals((Object)jndiName, (Object)"jdbc/testDS1");
    }

    @Test
    public void testSetCustomJndiName() {
        this.jpaSettings.setDataSourceJndiName("jdbc/myDS");
        String jndiName = this.jpaSettings.getDataSourceJndiName();
        Assert.assertEquals((Object)jndiName, (Object)"jdbc/myDS");
    }

    @Test
    public void testDefaultJndiName() throws Exception {
        PowerMockito.when((Object)this.jpaSettings, (Method)PowerMockito.method(JpaSettings.class, (String)"getJndiNameFromPersistenceXml", (Class[])new Class[0])).withNoArguments().thenReturn(null);
        String jndiName = this.jpaSettings.getDataSourceJndiName();
        Assert.assertEquals((Object)jndiName, (Object)"java:jboss/datasources/ExampleDS");
    }

    @Test
    public void testDefaultSystemProperty() throws Exception {
        PowerMockito.when((Object)this.jpaSettings, (Method)PowerMockito.method(JpaSettings.class, (String)"getJndiNameFromPersistenceXml", (Class[])new Class[0])).withNoArguments().thenReturn(null);
        System.setProperty("org.kie.ds.jndi", "jdbc/MyDS");
        String jndiName = this.jpaSettings.getDataSourceJndiName();
        Assert.assertEquals((Object)jndiName, (Object)"jdbc/MyDS");
    }
}

