/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.Transformable;
import org.jbpm.persistence.api.PersistentCorrelationKey;
import org.jbpm.persistence.api.PersistentProcessInstance;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.jbpm.persistence.api.ProcessPersistenceContextManager;
import org.jbpm.persistence.api.integration.EventManagerProvider;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.persistence.api.integration.model.CaseInstanceView;
import org.jbpm.persistence.api.integration.model.ProcessInstanceView;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.correlation.CorrelationPropertyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class JPAProcessInstanceManager
implements ProcessInstanceManager {
    private InternalKnowledgeRuntime kruntime;
    private volatile transient Map<Long, ProcessInstance> processInstances = new ConcurrentHashMap<Long, ProcessInstance>();

    public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public void addProcessInstance(ProcessInstance processInstance, CorrelationKey correlationKey) {
        ProcessInstanceInfo processInstanceInfo = new ProcessInstanceInfo(processInstance, this.kruntime.getEnvironment());
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        processInstanceInfo = (ProcessInstanceInfo)context.persist((PersistentProcessInstance)processInstanceInfo);
        ((org.jbpm.process.instance.ProcessInstance)processInstance).setId(processInstanceInfo.getId().longValue());
        processInstanceInfo.updateLastReadDate();
        if (correlationKey == null) {
            correlationKey = new CorrelationKeyInfo();
            ((CorrelationKeyInfo)correlationKey).addProperty(new CorrelationPropertyInfo(null, processInstanceInfo.getId().toString()));
            ((CorrelationKeyInfo)correlationKey).setName(correlationKey.toExternalForm());
            ((org.jbpm.process.instance.ProcessInstance)processInstance).getMetaData().put("CorrelationKey", correlationKey);
        }
        CorrelationKeyInfo correlationKeyInfo = (CorrelationKeyInfo)correlationKey;
        correlationKeyInfo.setProcessInstanceId(processInstanceInfo.getId());
        context.persist((PersistentCorrelationKey)correlationKeyInfo);
        this.internalAddProcessInstance(processInstance);
        EventManagerProvider.getInstance().get().create(this.getInstanceViewFor(processInstance));
    }

    public void internalAddProcessInstance(ProcessInstance processInstance) {
        if (((ConcurrentHashMap)this.processInstances).putIfAbsent(processInstance.getId(), processInstance) != null) {
            throw new ConcurrentModificationException("Duplicate process instance [" + processInstance.getProcessId() + "/" + processInstance.getId() + "] added to process instance manager.");
        }
    }

    public ProcessInstance getProcessInstance(long id) {
        return this.getProcessInstance(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInstance getProcessInstance(long id, boolean readOnly) {
        InternalRuntimeManager manager = (InternalRuntimeManager)this.kruntime.getEnvironment().get("RuntimeManager");
        if (manager != null) {
            manager.validate((KieSession)this.kruntime, (Context)ProcessInstanceIdContext.get((Long)id));
        }
        TransactionManager txm = (TransactionManager)this.kruntime.getEnvironment().get("org.kie.transaction.TransactionManager");
        org.jbpm.process.instance.ProcessInstance processInstance = null;
        processInstance = (org.jbpm.process.instance.ProcessInstance)this.processInstances.get(id);
        if (processInstance != null) {
            if (((WorkflowProcessInstanceImpl)processInstance).isPersisted() && !readOnly) {
                ProcessPersistenceContextManager ppcm = (ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
                ppcm.beginCommandScopedEntityManager();
                ProcessPersistenceContext context = ppcm.getProcessPersistenceContext();
                ProcessInstanceInfo processInstanceInfo = (ProcessInstanceInfo)context.findProcessInstanceInfo(Long.valueOf(id));
                if (processInstanceInfo == null) {
                    return null;
                }
                TransactionManagerHelper.addToUpdatableSet((TransactionManager)txm, (Transformable)processInstanceInfo);
                processInstanceInfo.updateLastReadDate();
                EventManagerProvider.getInstance().get().update(this.getInstanceViewFor((ProcessInstance)processInstance));
            }
            return processInstance;
        }
        try {
            Long parentProcessInstanceId;
            ProcessPersistenceContextManager ppcm = (ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
            ppcm.beginCommandScopedEntityManager();
            ProcessPersistenceContext context = ppcm.getProcessPersistenceContext();
            ProcessInstanceInfo processInstanceInfo = (ProcessInstanceInfo)context.findProcessInstanceInfo(Long.valueOf(id));
            if (processInstanceInfo == null) {
                ProcessInstance processInstance2 = null;
                return processInstance2;
            }
            processInstance = (org.jbpm.process.instance.ProcessInstance)processInstanceInfo.getProcessInstance(this.kruntime, this.kruntime.getEnvironment(), readOnly);
            if (!readOnly) {
                processInstanceInfo.updateLastReadDate();
                TransactionManagerHelper.addToUpdatableSet((TransactionManager)txm, (Transformable)processInstanceInfo);
            }
            if (((ProcessInstanceImpl)processInstance).getProcessXml() == null) {
                Process process = this.kruntime.getKieBase().getProcess(processInstance.getProcessId());
                if (process == null) {
                    throw new IllegalArgumentException("Could not find process " + processInstance.getProcessId());
                }
                processInstance.setProcess(process);
            }
            if ((parentProcessInstanceId = (Long)((ProcessInstanceImpl)processInstance).getMetaData().get("ParentProcessInstanceId")) != null) {
                this.kruntime.getProcessInstance(parentProcessInstanceId.longValue());
            }
            if (processInstance.getKnowledgeRuntime() == null && !readOnly) {
                processInstance.setKnowledgeRuntime(this.kruntime);
                ((ProcessInstanceImpl)processInstance).reconnect();
            }
            if (readOnly) {
                this.internalRemoveProcessInstance((ProcessInstance)processInstance);
            }
            org.jbpm.process.instance.ProcessInstance processInstance3 = processInstance;
            return processInstance3;
        }
        finally {
            if (!readOnly && processInstance != null) {
                EventManagerProvider.getInstance().get().update(this.getInstanceViewFor((ProcessInstance)processInstance));
            }
        }
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return Collections.unmodifiableCollection(this.processInstances.values());
    }

    public void removeProcessInstance(ProcessInstance processInstance) {
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        ProcessInstanceInfo processInstanceInfo = (ProcessInstanceInfo)context.findProcessInstanceInfo(Long.valueOf(processInstance.getId()));
        if (processInstanceInfo != null) {
            context.remove((PersistentProcessInstance)processInstanceInfo);
        }
        this.internalRemoveProcessInstance(processInstance);
        EventManagerProvider.getInstance().get().delete(this.getInstanceViewFor(processInstance));
    }

    public void internalRemoveProcessInstance(ProcessInstance processInstance) {
        this.processInstances.remove(processInstance.getId());
    }

    public void clearProcessInstances() {
        for (ProcessInstance processInstance : new ArrayList<ProcessInstance>(this.processInstances.values())) {
            ((ProcessInstanceImpl)processInstance).disconnect();
        }
    }

    public void clearProcessInstancesState() {
        try {
            TimerManager timerManager = ((InternalProcessRuntime)this.kruntime.getProcessRuntime()).getTimerManager();
            for (ProcessInstance processInstance : new ArrayList<ProcessInstance>(this.processInstances.values())) {
                WorkflowProcessInstance pi = (WorkflowProcessInstance)processInstance;
                for (NodeInstance nodeInstance : pi.getNodeInstances()) {
                    List timerIds;
                    if (nodeInstance instanceof TimerNodeInstance) {
                        if (((TimerNodeInstance)nodeInstance).getTimerInstance() == null) continue;
                        timerManager.cancelTimer(((TimerNodeInstance)nodeInstance).getTimerInstance().getId());
                        continue;
                    }
                    if (!(nodeInstance instanceof StateBasedNodeInstance) || (timerIds = ((StateBasedNodeInstance)nodeInstance).getTimerInstances()) == null) continue;
                    for (Long id : timerIds) {
                        timerManager.cancelTimer(id.longValue());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        ProcessPersistenceContext context = ((ProcessPersistenceContextManager)this.kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager")).getProcessPersistenceContext();
        Long processInstanceId = context.getProcessInstanceByCorrelationKey(correlationKey);
        if (processInstanceId == null) {
            return null;
        }
        return this.getProcessInstance(processInstanceId);
    }

    protected InstanceView<ProcessInstance> getInstanceViewFor(ProcessInstance pi) {
        if (((WorkflowProcess)pi.getProcess()).isDynamic()) {
            return new CaseInstanceView(pi);
        }
        return new ProcessInstanceView(pi);
    }
}

